
package io.cucumber.messages.types;

import java.util.ArrayList;
import java.util.List;


/**
 * A row in a table
 * 
 */
public class TableRow {

    /**
     * *
     *  Points to a line and a column in a text file
     * (Required)
     * 
     */
    private Location location;
    /**
     * Cells in the row
     * (Required)
     * 
     */
    private List<TableCell> cells = new ArrayList<TableCell>();
    /**
     * 
     * (Required)
     * 
     */
    private String id;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TableRow() {
    }

    /**
     * 
     * @param cells
     * @param location
     * @param id
     */
    public TableRow(Location location, List<TableCell> cells, String id) {
        super();
        this.location = location;
        this.cells = cells;
        this.id = id;
    }

    /**
     * *
     *  Points to a line and a column in a text file
     * (Required)
     * 
     */
    public Location getLocation() {
        return location;
    }

    /**
     * *
     *  Points to a line and a column in a text file
     * (Required)
     * 
     */
    public void setLocation(Location location) {
        this.location = location;
    }

    /**
     * Cells in the row
     * (Required)
     * 
     */
    public List<TableCell> getCells() {
        return cells;
    }

    /**
     * Cells in the row
     * (Required)
     * 
     */
    public void setCells(List<TableCell> cells) {
        this.cells = cells;
    }

    /**
     * 
     * (Required)
     * 
     */
    public String getId() {
        return id;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TableRow.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("location");
        sb.append('=');
        sb.append(((this.location == null)?"<null>":this.location));
        sb.append(',');
        sb.append("cells");
        sb.append('=');
        sb.append(((this.cells == null)?"<null>":this.cells));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.location == null)? 0 :this.location.hashCode()));
        result = ((result* 31)+((this.cells == null)? 0 :this.cells.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof TableRow) == false) {
            return false;
        }
        TableRow rhs = ((TableRow) other);
        return ((((this.location == rhs.location)||((this.location!= null)&&this.location.equals(rhs.location)))&&((this.cells == rhs.cells)||((this.cells!= null)&&this.cells.equals(rhs.cells))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))));
    }

}
