
package io.cucumber.messages.types;


public class TestRunStarted {

    /**
     * 
     * (Required)
     * 
     */
    private Timestamp timestamp;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TestRunStarted() {
    }

    /**
     * 
     * @param timestamp
     */
    public TestRunStarted(Timestamp timestamp) {
        super();
        this.timestamp = timestamp;
    }

    /**
     * 
     * (Required)
     * 
     */
    public Timestamp getTimestamp() {
        return timestamp;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setTimestamp(Timestamp timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TestRunStarted.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("timestamp");
        sb.append('=');
        sb.append(((this.timestamp == null)?"<null>":this.timestamp));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.timestamp == null)? 0 :this.timestamp.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof TestRunStarted) == false) {
            return false;
        }
        TestRunStarted rhs = ((TestRunStarted) other);
        return ((this.timestamp == rhs.timestamp)||((this.timestamp!= null)&&this.timestamp.equals(rhs.timestamp)));
    }

}
