/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.messages.types;

import io.cucumber.messages.types.Examples;
import io.cucumber.messages.types.Location;
import io.cucumber.messages.types.Step;
import io.cucumber.messages.types.Tag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class Scenario {
    private final Location location;
    private final List<Tag> tags;
    private final String keyword;
    private final String name;
    private final String description;
    private final List<Step> steps;
    private final List<Examples> examples;
    private final String id;

    public Scenario(Location location, List<Tag> tags, String keyword, String name, String description, List<Step> steps, List<Examples> examples, String id) {
        this.location = Objects.requireNonNull(location, "Scenario.location cannot be null");
        this.tags = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(tags, "Scenario.tags cannot be null")));
        this.keyword = Objects.requireNonNull(keyword, "Scenario.keyword cannot be null");
        this.name = Objects.requireNonNull(name, "Scenario.name cannot be null");
        this.description = Objects.requireNonNull(description, "Scenario.description cannot be null");
        this.steps = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(steps, "Scenario.steps cannot be null")));
        this.examples = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(examples, "Scenario.examples cannot be null")));
        this.id = Objects.requireNonNull(id, "Scenario.id cannot be null");
    }

    public Location getLocation() {
        return this.location;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<Step> getSteps() {
        return this.steps;
    }

    public List<Examples> getExamples() {
        return this.examples;
    }

    public String getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Scenario that = (Scenario)o;
        return this.location.equals(that.location) && this.tags.equals(that.tags) && this.keyword.equals(that.keyword) && this.name.equals(that.name) && this.description.equals(that.description) && this.steps.equals(that.steps) && this.examples.equals(that.examples) && this.id.equals(that.id);
    }

    public int hashCode() {
        return Objects.hash(this.location, this.tags, this.keyword, this.name, this.description, this.steps, this.examples, this.id);
    }

    public String toString() {
        return "Scenario{location=" + this.location + ", tags=" + this.tags + ", keyword=" + this.keyword + ", name=" + this.name + ", description=" + this.description + ", steps=" + this.steps + ", examples=" + this.examples + ", id=" + this.id + '}';
    }
}

