/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.messages.types;

import java.util.Collection;
import java.util.List;
import java.util.Objects;

public final class JavaMethod {
    private final String className;
    private final String methodName;
    private final List<String> methodParameterTypes;

    public JavaMethod(String className, String methodName, List<String> methodParameterTypes) {
        this.className = Objects.requireNonNull(className, "JavaMethod.className cannot be null");
        this.methodName = Objects.requireNonNull(methodName, "JavaMethod.methodName cannot be null");
        this.methodParameterTypes = List.copyOf((Collection)Objects.requireNonNull(methodParameterTypes, "JavaMethod.methodParameterTypes cannot be null"));
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public List<String> getMethodParameterTypes() {
        return this.methodParameterTypes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaMethod that = (JavaMethod)o;
        return this.className.equals(that.className) && this.methodName.equals(that.methodName) && this.methodParameterTypes.equals(that.methodParameterTypes);
    }

    public int hashCode() {
        return Objects.hash(this.className, this.methodName, this.methodParameterTypes);
    }

    public String toString() {
        return "JavaMethod{className=" + this.className + ", methodName=" + this.methodName + ", methodParameterTypes=" + String.valueOf(this.methodParameterTypes) + "}";
    }
}

