/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.messages.types;

import io.cucumber.messages.types.Location;
import io.cucumber.messages.types.PickleStep;
import io.cucumber.messages.types.PickleTag;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jspecify.annotations.Nullable;

public final class Pickle {
    private final String id;
    private final String uri;
    private final @Nullable Location location;
    private final String name;
    private final String language;
    private final List<PickleStep> steps;
    private final List<PickleTag> tags;
    private final List<String> astNodeIds;

    public Pickle(String id, String uri, @Nullable Location location, String name, String language, List<PickleStep> steps, List<PickleTag> tags, List<String> astNodeIds) {
        this.id = Objects.requireNonNull(id, "Pickle.id cannot be null");
        this.uri = Objects.requireNonNull(uri, "Pickle.uri cannot be null");
        this.location = location;
        this.name = Objects.requireNonNull(name, "Pickle.name cannot be null");
        this.language = Objects.requireNonNull(language, "Pickle.language cannot be null");
        this.steps = List.copyOf((Collection)Objects.requireNonNull(steps, "Pickle.steps cannot be null"));
        this.tags = List.copyOf((Collection)Objects.requireNonNull(tags, "Pickle.tags cannot be null"));
        this.astNodeIds = List.copyOf((Collection)Objects.requireNonNull(astNodeIds, "Pickle.astNodeIds cannot be null"));
    }

    public String getId() {
        return this.id;
    }

    public String getUri() {
        return this.uri;
    }

    public Optional<Location> getLocation() {
        return Optional.ofNullable(this.location);
    }

    public String getName() {
        return this.name;
    }

    public String getLanguage() {
        return this.language;
    }

    public List<PickleStep> getSteps() {
        return this.steps;
    }

    public List<PickleTag> getTags() {
        return this.tags;
    }

    public List<String> getAstNodeIds() {
        return this.astNodeIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pickle that = (Pickle)o;
        return this.id.equals(that.id) && this.uri.equals(that.uri) && Objects.equals(this.location, that.location) && this.name.equals(that.name) && this.language.equals(that.language) && this.steps.equals(that.steps) && this.tags.equals(that.tags) && this.astNodeIds.equals(that.astNodeIds);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.uri, this.location, this.name, this.language, this.steps, this.tags, this.astNodeIds);
    }

    public String toString() {
        return "Pickle{id=" + this.id + ", uri=" + this.uri + ", location=" + String.valueOf(this.location) + ", name=" + this.name + ", language=" + this.language + ", steps=" + String.valueOf(this.steps) + ", tags=" + String.valueOf(this.tags) + ", astNodeIds=" + String.valueOf(this.astNodeIds) + "}";
    }
}

