/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.messages.types;

import io.cucumber.messages.types.PickleDocString;
import io.cucumber.messages.types.PickleTable;
import java.util.Objects;
import java.util.Optional;
import org.jspecify.annotations.Nullable;

public final class PickleStepArgument {
    private final @Nullable PickleDocString docString;
    private final @Nullable PickleTable dataTable;

    public static PickleStepArgument of(PickleDocString docString) {
        return new PickleStepArgument(Objects.requireNonNull(docString, "PickleStepArgument.docString cannot be null"), null);
    }

    public static PickleStepArgument of(PickleTable dataTable) {
        return new PickleStepArgument(null, Objects.requireNonNull(dataTable, "PickleStepArgument.dataTable cannot be null"));
    }

    public PickleStepArgument(@Nullable PickleDocString docString, @Nullable PickleTable dataTable) {
        this.docString = docString;
        this.dataTable = dataTable;
    }

    public Optional<PickleDocString> getDocString() {
        return Optional.ofNullable(this.docString);
    }

    public Optional<PickleTable> getDataTable() {
        return Optional.ofNullable(this.dataTable);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PickleStepArgument that = (PickleStepArgument)o;
        return Objects.equals(this.docString, that.docString) && Objects.equals(this.dataTable, that.dataTable);
    }

    public int hashCode() {
        return Objects.hash(this.docString, this.dataTable);
    }

    public String toString() {
        return "PickleStepArgument{docString=" + String.valueOf(this.docString) + ", dataTable=" + String.valueOf(this.dataTable) + "}";
    }
}

