/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.messages.types;

import io.cucumber.messages.types.TestStepResult;
import io.cucumber.messages.types.Timestamp;
import java.util.Objects;

public final class TestStepFinished {
    private final String testCaseStartedId;
    private final String testStepId;
    private final TestStepResult testStepResult;
    private final Timestamp timestamp;

    public TestStepFinished(String testCaseStartedId, String testStepId, TestStepResult testStepResult, Timestamp timestamp) {
        this.testCaseStartedId = Objects.requireNonNull(testCaseStartedId, "TestStepFinished.testCaseStartedId cannot be null");
        this.testStepId = Objects.requireNonNull(testStepId, "TestStepFinished.testStepId cannot be null");
        this.testStepResult = Objects.requireNonNull(testStepResult, "TestStepFinished.testStepResult cannot be null");
        this.timestamp = Objects.requireNonNull(timestamp, "TestStepFinished.timestamp cannot be null");
    }

    public String getTestCaseStartedId() {
        return this.testCaseStartedId;
    }

    public String getTestStepId() {
        return this.testStepId;
    }

    public TestStepResult getTestStepResult() {
        return this.testStepResult;
    }

    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestStepFinished that = (TestStepFinished)o;
        return this.testCaseStartedId.equals(that.testCaseStartedId) && this.testStepId.equals(that.testStepId) && this.testStepResult.equals(that.testStepResult) && this.timestamp.equals(that.timestamp);
    }

    public int hashCode() {
        return Objects.hash(this.testCaseStartedId, this.testStepId, this.testStepResult, this.timestamp);
    }

    public String toString() {
        return "TestStepFinished{testCaseStartedId=" + this.testCaseStartedId + ", testStepId=" + this.testStepId + ", testStepResult=" + String.valueOf(this.testStepResult) + ", timestamp=" + String.valueOf(this.timestamp) + "}";
    }
}

