/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.prettyformatter;

import io.cucumber.messages.types.TestStepResultStatus;
import io.cucumber.prettyformatter.Ansi;
import java.util.AbstractMap;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;

public final class Theme {
    private final Map<Element, Map.Entry<Ansi, Ansi>> styleByElement;
    private final Map<Element, Map<TestStepResultStatus, Map.Entry<Ansi, Ansi>>> styleByStatusByElement;
    private final Map<TestStepResultStatus, String> statusIconByStatus;
    private final Map<TestStepResultStatus, String> progressIconByStatus;

    private Theme(Map<Element, Map.Entry<Ansi, Ansi>> styleByElement, Map<Element, Map<TestStepResultStatus, Map.Entry<Ansi, Ansi>>> styleByStatusByElement, Map<TestStepResultStatus, String> statusIconByStatus, Map<TestStepResultStatus, String> progressIconByStatus) {
        this.styleByElement = Objects.requireNonNull(styleByElement);
        this.styleByStatusByElement = Objects.requireNonNull(styleByStatusByElement);
        this.statusIconByStatus = statusIconByStatus;
        this.progressIconByStatus = progressIconByStatus;
    }

    public static Theme cucumber() {
        return Theme.builder().style(Element.ATTACHMENT, Ansi.with(Ansi.Attributes.FOREGROUND_BLUE), Ansi.with(Ansi.Attributes.FOREGROUND_DEFAULT)).style(Element.FEATURE_KEYWORD, Ansi.with(Ansi.Attributes.BOLD), Ansi.with(Ansi.Attributes.BOLD_OFF)).style(Element.LOCATION, Ansi.with(Ansi.Attributes.FOREGROUND_BRIGHT_BLACK), Ansi.with(Ansi.Attributes.FOREGROUND_DEFAULT)).style(Element.RULE_KEYWORD, Ansi.with(Ansi.Attributes.BOLD), Ansi.with(Ansi.Attributes.BOLD_OFF)).style(Element.SCENARIO_KEYWORD, Ansi.with(Ansi.Attributes.BOLD), Ansi.with(Ansi.Attributes.BOLD_OFF)).style(Element.STEP, TestStepResultStatus.AMBIGUOUS, Ansi.with(Ansi.Attributes.FOREGROUND_RED), Ansi.with(Ansi.Attributes.FOREGROUND_DEFAULT)).style(Element.STEP, TestStepResultStatus.FAILED, Ansi.with(Ansi.Attributes.FOREGROUND_RED), Ansi.with(Ansi.Attributes.FOREGROUND_DEFAULT)).style(Element.STEP, TestStepResultStatus.PASSED, Ansi.with(Ansi.Attributes.FOREGROUND_GREEN), Ansi.with(Ansi.Attributes.FOREGROUND_DEFAULT)).style(Element.STEP, TestStepResultStatus.PENDING, Ansi.with(Ansi.Attributes.FOREGROUND_YELLOW), Ansi.with(Ansi.Attributes.FOREGROUND_DEFAULT)).style(Element.STEP, TestStepResultStatus.SKIPPED, Ansi.with(Ansi.Attributes.FOREGROUND_CYAN), Ansi.with(Ansi.Attributes.FOREGROUND_DEFAULT)).style(Element.STEP, TestStepResultStatus.UNDEFINED, Ansi.with(Ansi.Attributes.FOREGROUND_YELLOW), Ansi.with(Ansi.Attributes.FOREGROUND_DEFAULT)).style(Element.STEP_ARGUMENT, Ansi.with(Ansi.Attributes.BOLD), Ansi.with(Ansi.Attributes.BOLD_OFF)).style(Element.STEP_KEYWORD, Ansi.with(Ansi.Attributes.BOLD), Ansi.with(Ansi.Attributes.BOLD_OFF)).statusIcon(TestStepResultStatus.AMBIGUOUS, "\u2718").style(Element.STATUS_ICON, TestStepResultStatus.AMBIGUOUS, Ansi.with(Ansi.Attributes.FOREGROUND_RED), Ansi.with(Ansi.Attributes.FOREGROUND_DEFAULT)).statusIcon(TestStepResultStatus.FAILED, "\u2718").style(Element.STATUS_ICON, TestStepResultStatus.FAILED, Ansi.with(Ansi.Attributes.FOREGROUND_RED), Ansi.with(Ansi.Attributes.FOREGROUND_DEFAULT)).statusIcon(TestStepResultStatus.PASSED, "\u2714").style(Element.STATUS_ICON, TestStepResultStatus.PASSED, Ansi.with(Ansi.Attributes.FOREGROUND_GREEN), Ansi.with(Ansi.Attributes.FOREGROUND_DEFAULT)).statusIcon(TestStepResultStatus.PENDING, "\u25a0").style(Element.STATUS_ICON, TestStepResultStatus.PENDING, Ansi.with(Ansi.Attributes.FOREGROUND_YELLOW), Ansi.with(Ansi.Attributes.FOREGROUND_DEFAULT)).statusIcon(TestStepResultStatus.SKIPPED, "\u21b7").style(Element.STATUS_ICON, TestStepResultStatus.SKIPPED, Ansi.with(Ansi.Attributes.FOREGROUND_CYAN), Ansi.with(Ansi.Attributes.FOREGROUND_DEFAULT)).statusIcon(TestStepResultStatus.UNDEFINED, "\u25a0").style(Element.STATUS_ICON, TestStepResultStatus.UNDEFINED, Ansi.with(Ansi.Attributes.FOREGROUND_YELLOW), Ansi.with(Ansi.Attributes.FOREGROUND_DEFAULT)).progressIcon(TestStepResultStatus.AMBIGUOUS, "A").style(Element.PROGRESS_ICON, TestStepResultStatus.AMBIGUOUS, Ansi.with(Ansi.Attributes.FOREGROUND_RED), Ansi.with(Ansi.Attributes.FOREGROUND_DEFAULT)).progressIcon(TestStepResultStatus.FAILED, "F").style(Element.PROGRESS_ICON, TestStepResultStatus.FAILED, Ansi.with(Ansi.Attributes.FOREGROUND_RED), Ansi.with(Ansi.Attributes.FOREGROUND_DEFAULT)).progressIcon(TestStepResultStatus.PASSED, ".").style(Element.PROGRESS_ICON, TestStepResultStatus.PASSED, Ansi.with(Ansi.Attributes.FOREGROUND_GREEN), Ansi.with(Ansi.Attributes.FOREGROUND_DEFAULT)).progressIcon(TestStepResultStatus.PENDING, "P").style(Element.PROGRESS_ICON, TestStepResultStatus.PENDING, Ansi.with(Ansi.Attributes.FOREGROUND_YELLOW), Ansi.with(Ansi.Attributes.FOREGROUND_DEFAULT)).progressIcon(TestStepResultStatus.SKIPPED, "-").style(Element.PROGRESS_ICON, TestStepResultStatus.SKIPPED, Ansi.with(Ansi.Attributes.FOREGROUND_CYAN), Ansi.with(Ansi.Attributes.FOREGROUND_DEFAULT)).progressIcon(TestStepResultStatus.UNDEFINED, "U").style(Element.PROGRESS_ICON, TestStepResultStatus.UNDEFINED, Ansi.with(Ansi.Attributes.FOREGROUND_YELLOW), Ansi.with(Ansi.Attributes.FOREGROUND_DEFAULT)).build();
    }

    public static Theme none() {
        return Theme.builder().build();
    }

    public static Theme plain() {
        return Theme.builder().statusIcon(TestStepResultStatus.AMBIGUOUS, "\u2718").statusIcon(TestStepResultStatus.FAILED, "\u2718").statusIcon(TestStepResultStatus.PASSED, "\u2714").statusIcon(TestStepResultStatus.PENDING, "\u25a0").statusIcon(TestStepResultStatus.SKIPPED, "\u21b7").statusIcon(TestStepResultStatus.UNDEFINED, "\u25a0").progressIcon(TestStepResultStatus.AMBIGUOUS, "A").progressIcon(TestStepResultStatus.FAILED, "F").progressIcon(TestStepResultStatus.PASSED, ".").progressIcon(TestStepResultStatus.PENDING, "P").progressIcon(TestStepResultStatus.SKIPPED, "-").progressIcon(TestStepResultStatus.UNDEFINED, "U").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    String style(Element element, String text) {
        Map.Entry<Ansi, Ansi> ansiStyle = this.findAnsiBy(element);
        return ansiStyle == null ? text : ansiStyle.getKey() + text + ansiStyle.getValue();
    }

    String style(Element element, TestStepResultStatus status, String text) {
        Map.Entry<Ansi, Ansi> ansiStyle = this.findAnsiBy(element, status);
        return ansiStyle == null ? text : ansiStyle.getKey() + text + ansiStyle.getValue();
    }

    String beginStyle(Element element) {
        Map.Entry<Ansi, Ansi> style = this.findAnsiBy(element);
        return style == null ? "" : style.getKey().toString();
    }

    String beginStyle(Element element, TestStepResultStatus status) {
        Map.Entry<Ansi, Ansi> style = this.findAnsiBy(element, status);
        return style == null ? "" : style.getKey().toString();
    }

    String endStyle(Element element) {
        Map.Entry<Ansi, Ansi> style = this.findAnsiBy(element);
        return style == null ? "" : style.getValue().toString();
    }

    String endStyle(Element element, TestStepResultStatus status) {
        Map.Entry<Ansi, Ansi> style = this.findAnsiBy(element, status);
        return style == null ? "" : style.getValue().toString();
    }

    String progressIcon(TestStepResultStatus status) {
        return this.progressIconByStatus.getOrDefault(status, " ");
    }

    String statusIcon(TestStepResultStatus status) {
        return this.statusIconByStatus.getOrDefault(status, " ");
    }

    private Map.Entry<Ansi, Ansi> findAnsiBy(Element element) {
        return this.styleByElement.get((Object)element);
    }

    private Map.Entry<Ansi, Ansi> findAnsiBy(Element element, TestStepResultStatus status) {
        Map<TestStepResultStatus, Map.Entry<Ansi, Ansi>> styleByStatus = this.styleByStatusByElement.get((Object)element);
        return styleByStatus == null ? null : styleByStatus.get(status);
    }

    boolean hasStatusIcons() {
        return !this.statusIconByStatus.isEmpty();
    }

    public static final class Builder {
        private final EnumMap<TestStepResultStatus, String> statusIconByStatus = new EnumMap(TestStepResultStatus.class);
        private final EnumMap<TestStepResultStatus, String> progressIconByStatus = new EnumMap(TestStepResultStatus.class);
        private final EnumMap<Element, Map.Entry<Ansi, Ansi>> styleByElement = new EnumMap(Element.class);
        private final EnumMap<Element, Map<TestStepResultStatus, Map.Entry<Ansi, Ansi>>> styleByStatusByElement = new EnumMap(Element.class);

        private Builder() {
        }

        public Builder style(Element element, Ansi style, Ansi resetStyle) {
            Objects.requireNonNull(element);
            Objects.requireNonNull(style);
            Objects.requireNonNull(resetStyle);
            this.styleByElement.put(element, new AbstractMap.SimpleEntry<Ansi, Ansi>(style, resetStyle));
            return this;
        }

        public Builder statusIcon(TestStepResultStatus status, String icon) {
            Objects.requireNonNull(status);
            Objects.requireNonNull(icon);
            this.statusIconByStatus.put(status, icon);
            return this;
        }

        public Builder progressIcon(TestStepResultStatus status, String icon) {
            Objects.requireNonNull(status);
            Objects.requireNonNull(icon);
            this.progressIconByStatus.put(status, icon);
            return this;
        }

        public Builder style(Element element, TestStepResultStatus status, Ansi style, Ansi resetStyle) {
            Objects.requireNonNull(element);
            Objects.requireNonNull(status);
            Objects.requireNonNull(style);
            Objects.requireNonNull(resetStyle);
            this.styleByStatusByElement.computeIfAbsent(element, e1 -> new EnumMap(TestStepResultStatus.class)).put(status, new AbstractMap.SimpleEntry<Ansi, Ansi>(style, resetStyle));
            return this;
        }

        public Theme build() {
            return new Theme(new EnumMap<Element, Map.Entry<Ansi, Ansi>>(this.styleByElement), new EnumMap<Element, Map<TestStepResultStatus, Map.Entry<Ansi, Ansi>>>(this.styleByStatusByElement), new EnumMap<TestStepResultStatus, String>(this.statusIconByStatus), new EnumMap<TestStepResultStatus, String>(this.progressIconByStatus));
        }
    }

    public static enum Element {
        ATTACHMENT,
        DATA_TABLE,
        DATA_TABLE_BORDER,
        DATA_TABLE_CONTENT,
        DOC_STRING,
        DOC_STRING_CONTENT,
        DOC_STRING_MEDIA_TYPE,
        DOC_STRING_DELIMITER,
        FEATURE,
        FEATURE_KEYWORD,
        FEATURE_NAME,
        LOCATION,
        PROGRESS_ICON,
        RULE,
        RULE_KEYWORD,
        RULE_NAME,
        SCENARIO,
        SCENARIO_KEYWORD,
        SCENARIO_NAME,
        STATUS_ICON,
        STEP,
        STEP_ARGUMENT,
        STEP_KEYWORD,
        STEP_TEXT,
        TAG;

    }
}

