/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.query;

import io.cucumber.messages.types.Examples;
import io.cucumber.messages.types.Feature;
import io.cucumber.messages.types.GherkinDocument;
import io.cucumber.messages.types.Rule;
import io.cucumber.messages.types.Scenario;
import io.cucumber.messages.types.TableRow;
import java.util.Objects;
import java.util.Optional;

class GherkinDocumentElements {
    private final GherkinDocument document;
    private final Feature feature;
    private final Rule rule;
    private final Scenario scenario;
    private final Examples examples;
    private final TableRow example;
    private final Integer examplesIndex;
    private final Integer exampleIndex;

    GherkinDocumentElements(GherkinDocument document, Feature feature, Rule rule, Scenario scenario) {
        this(document, feature, rule, scenario, null, null, null, null);
    }

    GherkinDocumentElements(GherkinDocument document, Feature feature, Rule rule, Scenario scenario, Integer examplesIndex, Examples examples, Integer exampleIndex, TableRow example) {
        this.document = Objects.requireNonNull(document);
        this.feature = feature;
        this.rule = rule;
        this.scenario = scenario;
        this.examplesIndex = examplesIndex;
        this.examples = examples;
        this.exampleIndex = exampleIndex;
        this.example = example;
    }

    GherkinDocument document() {
        return this.document;
    }

    Optional<Feature> feature() {
        return Optional.ofNullable(this.feature);
    }

    Optional<Rule> rule() {
        return Optional.ofNullable(this.rule);
    }

    Optional<Scenario> scenario() {
        return Optional.ofNullable(this.scenario);
    }

    Optional<Examples> examples() {
        return Optional.ofNullable(this.examples);
    }

    Optional<TableRow> example() {
        return Optional.ofNullable(this.example);
    }

    Optional<Integer> examplesIndex() {
        return Optional.ofNullable(this.examplesIndex);
    }

    Optional<Integer> exampleIndex() {
        return Optional.ofNullable(this.exampleIndex);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GherkinDocumentElements that = (GherkinDocumentElements)o;
        return this.document.equals((Object)that.document) && this.feature.equals((Object)that.feature) && Objects.equals(this.rule, that.rule) && this.scenario.equals((Object)that.scenario) && Objects.equals(this.examples, that.examples) && Objects.equals(this.example, that.example) && Objects.equals(this.examplesIndex, that.examplesIndex) && Objects.equals(this.exampleIndex, that.exampleIndex);
    }

    public int hashCode() {
        return Objects.hash(this.document, this.feature, this.rule, this.scenario, this.examples, this.example, this.examplesIndex, this.exampleIndex);
    }
}

