/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.query;

import io.cucumber.messages.Convertor;
import io.cucumber.messages.TestStepResultStatusComparator;
import io.cucumber.messages.types.Attachment;
import io.cucumber.messages.types.Examples;
import io.cucumber.messages.types.Feature;
import io.cucumber.messages.types.GherkinDocument;
import io.cucumber.messages.types.Hook;
import io.cucumber.messages.types.Location;
import io.cucumber.messages.types.Meta;
import io.cucumber.messages.types.Pickle;
import io.cucumber.messages.types.PickleStep;
import io.cucumber.messages.types.Rule;
import io.cucumber.messages.types.Scenario;
import io.cucumber.messages.types.Step;
import io.cucumber.messages.types.StepDefinition;
import io.cucumber.messages.types.Suggestion;
import io.cucumber.messages.types.TableRow;
import io.cucumber.messages.types.TestCase;
import io.cucumber.messages.types.TestCaseFinished;
import io.cucumber.messages.types.TestCaseStarted;
import io.cucumber.messages.types.TestRunFinished;
import io.cucumber.messages.types.TestRunHookFinished;
import io.cucumber.messages.types.TestRunHookStarted;
import io.cucumber.messages.types.TestRunStarted;
import io.cucumber.messages.types.TestStep;
import io.cucumber.messages.types.TestStepFinished;
import io.cucumber.messages.types.TestStepResult;
import io.cucumber.messages.types.TestStepResultStatus;
import io.cucumber.messages.types.TestStepStarted;
import io.cucumber.messages.types.Timestamp;
import io.cucumber.messages.types.UndefinedParameterType;
import io.cucumber.query.Lineage;
import io.cucumber.query.Repository;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class Query {
    private final Repository repository;

    public Query(Repository repository) {
        this.repository = repository;
    }

    public Map<TestStepResultStatus, Long> countMostSevereTestStepResultStatus() {
        EnumMap<TestStepResultStatus, Long> results = new EnumMap<TestStepResultStatus, Long>(TestStepResultStatus.class);
        for (TestStepResultStatus value : TestStepResultStatus.values()) {
            results.put(value, 0L);
        }
        results.putAll(this.findAllTestCaseStarted().stream().map(this::findMostSevereTestStepResultBy).filter(Optional::isPresent).map(Optional::get).map(TestStepResult::getStatus).collect(Collectors.groupingBy(Function.identity(), LinkedHashMap::new, Collectors.counting())));
        return results;
    }

    public int countTestCasesStarted() {
        return this.findAllTestCaseStarted().size();
    }

    public List<Pickle> findAllPickles() {
        return new ArrayList<Pickle>(this.repository.pickleById.values());
    }

    public List<PickleStep> findAllPickleSteps() {
        return new ArrayList<PickleStep>(this.repository.pickleStepById.values());
    }

    public List<TestCaseStarted> findAllTestCaseStarted() {
        return this.repository.testCaseStartedById.values().stream().filter(element -> !this.findTestCaseFinishedBy((TestCaseStarted)element).filter(TestCaseFinished::getWillBeRetried).isPresent()).collect(Collectors.toList());
    }

    public List<StepDefinition> findAllStepDefinitions() {
        return new ArrayList<StepDefinition>(this.repository.stepDefinitionById.values());
    }

    public List<TestCaseFinished> findAllTestCaseFinished() {
        return this.repository.testCaseFinishedByTestCaseStartedId.values().stream().filter(testCaseFinished -> testCaseFinished.getWillBeRetried() == false).collect(Collectors.toList());
    }

    public List<TestStep> findAllTestSteps() {
        return new ArrayList<TestStep>(this.repository.testStepById.values());
    }

    public List<TestCase> findAllTestCases() {
        return new ArrayList<TestCase>(this.repository.testCaseById.values());
    }

    public List<TestStepStarted> findAllTestStepStarted() {
        return this.repository.testStepsStartedByTestCaseStartedId.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<TestStepFinished> findAllTestStepFinished() {
        return this.repository.testStepsFinishedByTestCaseStartedId.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<TestRunHookStarted> findAllTestRunHookStarted() {
        return new ArrayList<TestRunHookStarted>(this.repository.testRunHookStartedById.values());
    }

    public List<TestRunHookFinished> findAllTestRunHookFinished() {
        return new ArrayList<TestRunHookFinished>(this.repository.testRunHookFinishedByTestRunHookStartedId.values());
    }

    public List<UndefinedParameterType> findAllUndefinedParameterTypes() {
        return new ArrayList<UndefinedParameterType>(this.repository.undefinedParameterTypes);
    }

    public List<Attachment> findAttachmentsBy(TestStepFinished testStepFinished) {
        Objects.requireNonNull(testStepFinished);
        return this.repository.attachmentsByTestCaseStartedId.getOrDefault(testStepFinished.getTestCaseStartedId(), Collections.emptyList()).stream().filter(attachment -> attachment.getTestStepId().map(testStepId -> testStepFinished.getTestStepId().equals(testStepId)).orElse(false)).collect(Collectors.toList());
    }

    public List<Attachment> findAttachmentsBy(TestRunHookFinished testRunHookFinished) {
        Objects.requireNonNull(testRunHookFinished);
        List attachments = this.repository.attachmentsByTestRunHookStartedId.getOrDefault(testRunHookFinished.getTestRunHookStartedId(), Collections.emptyList());
        return new ArrayList<Attachment>(attachments);
    }

    public Optional<Hook> findHookBy(TestStep testStep) {
        Objects.requireNonNull(testStep);
        return testStep.getHookId().map(this.repository.hookById::get);
    }

    public Optional<Hook> findHookBy(TestRunHookStarted testRunHookStarted) {
        Objects.requireNonNull(testRunHookStarted);
        return Optional.ofNullable(this.repository.hookById.get(testRunHookStarted.getHookId()));
    }

    public Optional<Hook> findHookBy(TestRunHookFinished testRunHookFinished) {
        Objects.requireNonNull(testRunHookFinished);
        return this.findTestRunHookStartedBy(testRunHookFinished).flatMap(this::findHookBy);
    }

    public Optional<Meta> findMeta() {
        return Optional.ofNullable(this.repository.meta);
    }

    public Optional<TestStepResult> findMostSevereTestStepResultBy(TestCaseStarted testCaseStarted) {
        Objects.requireNonNull(testCaseStarted);
        return this.findTestStepsFinishedBy(testCaseStarted).stream().map(TestStepFinished::getTestStepResult).max(Comparator.comparing(TestStepResult::getStatus, new TestStepResultStatusComparator()));
    }

    public Optional<TestStepResult> findMostSevereTestStepResultBy(TestCaseFinished testCaseFinished) {
        Objects.requireNonNull(testCaseFinished);
        return this.findTestCaseStartedBy(testCaseFinished).flatMap(this::findMostSevereTestStepResultBy);
    }

    public Optional<Location> findLocationOf(Pickle pickle) {
        return this.findLineageBy(pickle).flatMap(lineage -> {
            if (lineage.example().isPresent()) {
                return lineage.example().map(TableRow::getLocation);
            }
            return lineage.scenario().map(Scenario::getLocation);
        });
    }

    public Optional<Pickle> findPickleBy(TestCaseStarted testCaseStarted) {
        Objects.requireNonNull(testCaseStarted);
        return this.findTestCaseBy(testCaseStarted).flatMap(this::findPickleBy);
    }

    public Optional<Pickle> findPickleBy(TestCaseFinished testCaseFinished) {
        Objects.requireNonNull(testCaseFinished);
        return this.findTestCaseStartedBy(testCaseFinished).flatMap(this::findPickleBy);
    }

    public Optional<Pickle> findPickleBy(TestCase testCase) {
        Objects.requireNonNull(testCase);
        return Optional.ofNullable(this.repository.pickleById.get(testCase.getPickleId()));
    }

    public Optional<Pickle> findPickleBy(TestStepStarted testStepStarted) {
        Objects.requireNonNull(testStepStarted);
        return this.findTestCaseBy(testStepStarted).map(TestCase::getPickleId).map(this.repository.pickleById::get);
    }

    public Optional<Pickle> findPickleBy(TestStepFinished testStepFinished) {
        Objects.requireNonNull(testStepFinished);
        return this.findTestCaseBy(testStepFinished).map(TestCase::getPickleId).map(this.repository.pickleById::get);
    }

    public Optional<PickleStep> findPickleStepBy(TestStep testStep) {
        Objects.requireNonNull(testStep);
        return testStep.getPickleStepId().map(this.repository.pickleStepById::get);
    }

    public List<Suggestion> findSuggestionsBy(PickleStep pickleStep) {
        Objects.requireNonNull(pickleStep);
        List suggestions = this.repository.suggestionsByPickleStepId.getOrDefault(pickleStep.getId(), Collections.emptyList());
        return new ArrayList<Suggestion>(suggestions);
    }

    public List<Suggestion> findSuggestionsBy(Pickle pickle) {
        Objects.requireNonNull(pickle);
        return pickle.getSteps().stream().map(this::findSuggestionsBy).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public Optional<Step> findStepBy(PickleStep pickleStep) {
        Objects.requireNonNull(pickleStep);
        String stepId = (String)pickleStep.getAstNodeIds().get(0);
        return Optional.ofNullable(this.repository.stepById.get(stepId));
    }

    public List<StepDefinition> findStepDefinitionsBy(TestStep testStep) {
        Objects.requireNonNull(testStep);
        return testStep.getStepDefinitionIds().map(ids -> ids.stream().map(this.repository.stepDefinitionById::get).filter(Objects::nonNull).collect(Collectors.toList())).orElseGet(Collections::emptyList);
    }

    public Optional<StepDefinition> findUnambiguousStepDefinitionBy(TestStep testStep) {
        Objects.requireNonNull(testStep);
        return testStep.getStepDefinitionIds().filter(ids -> ids.size() == 1).map(ids -> this.repository.stepDefinitionById.get(ids.get(0)));
    }

    public Optional<TestCase> findTestCaseBy(TestCaseStarted testCaseStarted) {
        Objects.requireNonNull(testCaseStarted);
        return Optional.ofNullable(this.repository.testCaseById.get(testCaseStarted.getTestCaseId()));
    }

    public Optional<TestCase> findTestCaseBy(TestCaseFinished testCaseFinished) {
        Objects.requireNonNull(testCaseFinished);
        return this.findTestCaseStartedBy(testCaseFinished).flatMap(this::findTestCaseBy);
    }

    public Optional<TestCase> findTestCaseBy(TestStepStarted testStepStarted) {
        Objects.requireNonNull(testStepStarted);
        return this.findTestCaseStartedBy(testStepStarted).flatMap(this::findTestCaseBy);
    }

    public Optional<TestCase> findTestCaseBy(TestStepFinished testStepFinished) {
        Objects.requireNonNull(testStepFinished);
        return this.findTestCaseStartedBy(testStepFinished).flatMap(this::findTestCaseBy);
    }

    public Optional<Duration> findTestCaseDurationBy(TestCaseStarted testCaseStarted) {
        Objects.requireNonNull(testCaseStarted);
        Timestamp started = testCaseStarted.getTimestamp();
        return this.findTestCaseFinishedBy(testCaseStarted).map(TestCaseFinished::getTimestamp).map(finished -> Duration.between(Convertor.toInstant((Timestamp)started), Convertor.toInstant((Timestamp)finished)));
    }

    public Optional<Duration> findTestCaseDurationBy(TestCaseFinished testCaseFinished) {
        Objects.requireNonNull(testCaseFinished);
        return this.findTestCaseStartedBy(testCaseFinished).flatMap(this::findTestCaseDurationBy);
    }

    public Optional<TestCaseStarted> findTestCaseStartedBy(TestStepStarted testStepStarted) {
        Objects.requireNonNull(testStepStarted);
        String testCaseStartedId = testStepStarted.getTestCaseStartedId();
        return Optional.ofNullable(this.repository.testCaseStartedById.get(testCaseStartedId));
    }

    public Optional<TestCaseStarted> findTestCaseStartedBy(TestCaseFinished testCaseFinished) {
        Objects.requireNonNull(testCaseFinished);
        String testCaseStartedId = testCaseFinished.getTestCaseStartedId();
        return Optional.ofNullable(this.repository.testCaseStartedById.get(testCaseStartedId));
    }

    public Optional<TestCaseStarted> findTestCaseStartedBy(TestStepFinished testStepFinished) {
        Objects.requireNonNull(testStepFinished);
        String testCaseStartedId = testStepFinished.getTestCaseStartedId();
        return Optional.ofNullable(this.repository.testCaseStartedById.get(testCaseStartedId));
    }

    public Optional<TestCaseFinished> findTestCaseFinishedBy(TestCaseStarted testCaseStarted) {
        Objects.requireNonNull(testCaseStarted);
        return Optional.ofNullable(this.repository.testCaseFinishedByTestCaseStartedId.get(testCaseStarted.getId()));
    }

    public Optional<TestRunHookFinished> findTestRunHookFinishedBy(TestRunHookStarted testRunHookStarted) {
        Objects.requireNonNull(testRunHookStarted);
        return Optional.ofNullable(this.repository.testRunHookFinishedByTestRunHookStartedId.get(testRunHookStarted.getId()));
    }

    public Optional<TestRunHookStarted> findTestRunHookStartedBy(TestRunHookFinished testRunHookFinished) {
        Objects.requireNonNull(testRunHookFinished);
        return Optional.ofNullable(this.repository.testRunHookStartedById.get(testRunHookFinished.getTestRunHookStartedId()));
    }

    public Optional<Duration> findTestRunDuration() {
        if (this.repository.testRunStarted == null || this.repository.testRunFinished == null) {
            return Optional.empty();
        }
        Duration between = Duration.between(Convertor.toInstant((Timestamp)this.repository.testRunStarted.getTimestamp()), Convertor.toInstant((Timestamp)this.repository.testRunFinished.getTimestamp()));
        return Optional.of(between);
    }

    public Optional<TestRunFinished> findTestRunFinished() {
        return Optional.ofNullable(this.repository.testRunFinished);
    }

    public Optional<TestRunStarted> findTestRunStarted() {
        return Optional.ofNullable(this.repository.testRunStarted);
    }

    public Optional<TestStep> findTestStepBy(TestStepStarted testStepStarted) {
        Objects.requireNonNull(testStepStarted);
        return Optional.ofNullable(this.repository.testStepById.get(testStepStarted.getTestStepId()));
    }

    public Optional<TestStep> findTestStepBy(TestStepFinished testStepFinished) {
        Objects.requireNonNull(testStepFinished);
        return Optional.ofNullable(this.repository.testStepById.get(testStepFinished.getTestStepId()));
    }

    public List<TestStepStarted> findTestStepsStartedBy(TestCaseStarted testCaseStarted) {
        Objects.requireNonNull(testCaseStarted);
        List testStepsStarted = this.repository.testStepsStartedByTestCaseStartedId.getOrDefault(testCaseStarted.getId(), Collections.emptyList());
        return new ArrayList<TestStepStarted>(testStepsStarted);
    }

    public List<TestStepStarted> findTestStepsStartedBy(TestCaseFinished testCaseFinished) {
        Objects.requireNonNull(testCaseFinished);
        List testStepsStarted = this.repository.testStepsStartedByTestCaseStartedId.getOrDefault(testCaseFinished.getTestCaseStartedId(), Collections.emptyList());
        return new ArrayList<TestStepStarted>(testStepsStarted);
    }

    public List<TestStepFinished> findTestStepsFinishedBy(TestCaseStarted testCaseStarted) {
        Objects.requireNonNull(testCaseStarted);
        List testStepsFinished = this.repository.testStepsFinishedByTestCaseStartedId.getOrDefault(testCaseStarted.getId(), Collections.emptyList());
        return new ArrayList<TestStepFinished>(testStepsFinished);
    }

    public List<TestStepFinished> findTestStepsFinishedBy(TestCaseFinished testCaseFinished) {
        Objects.requireNonNull(testCaseFinished);
        return this.findTestCaseStartedBy(testCaseFinished).map(this::findTestStepsFinishedBy).orElseGet(ArrayList::new);
    }

    public List<Map.Entry<TestStepFinished, TestStep>> findTestStepFinishedAndTestStepBy(TestCaseStarted testCaseStarted) {
        return this.findTestStepsFinishedBy(testCaseStarted).stream().map(testStepFinished -> this.findTestStepBy((TestStepFinished)testStepFinished).map(testStep -> new AbstractMap.SimpleEntry<TestStepFinished, TestStep>((TestStepFinished)testStepFinished, (TestStep)testStep))).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    public Optional<Lineage> findLineageBy(GherkinDocument element) {
        Objects.requireNonNull(element);
        return Optional.ofNullable(this.repository.lineageById.get(element.getUri()));
    }

    public Optional<Lineage> findLineageBy(Feature element) {
        Objects.requireNonNull(element);
        return Optional.ofNullable(this.repository.lineageById.get(element));
    }

    public Optional<Lineage> findLineageBy(Rule element) {
        Objects.requireNonNull(element);
        return Optional.ofNullable(this.repository.lineageById.get(element.getId()));
    }

    public Optional<Lineage> findLineageBy(Scenario element) {
        Objects.requireNonNull(element);
        return Optional.ofNullable(this.repository.lineageById.get(element.getId()));
    }

    public Optional<Lineage> findLineageBy(Examples element) {
        Objects.requireNonNull(element);
        return Optional.ofNullable(this.repository.lineageById.get(element.getId()));
    }

    public Optional<Lineage> findLineageBy(TableRow element) {
        Objects.requireNonNull(element);
        return Optional.ofNullable(this.repository.lineageById.get(element.getId()));
    }

    public Optional<Lineage> findLineageBy(Pickle pickle) {
        Objects.requireNonNull(pickle);
        List astNodeIds = pickle.getAstNodeIds();
        String pickleAstNodeId = (String)astNodeIds.get(astNodeIds.size() - 1);
        return Optional.ofNullable(this.repository.lineageById.get(pickleAstNodeId));
    }

    public Optional<Lineage> findLineageBy(TestCaseStarted testCaseStarted) {
        return this.findPickleBy(testCaseStarted).flatMap(this::findLineageBy);
    }
}

