/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.usageformatter;

import io.cucumber.usageformatter.MessagesToUsageWriter;
import io.cucumber.usageformatter.SourceReferenceFormatter;
import io.cucumber.usageformatter.Table;
import io.cucumber.usageformatter.TableFormatter;
import io.cucumber.usageformatter.UsageReport;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class UnusedReportSerializer
implements MessagesToUsageWriter.Serializer {
    private final SourceReferenceFormatter sourceReferenceFormatter = new SourceReferenceFormatter(Function.identity());
    private final String[] headers = new String[]{"Location", "Expression"};
    private final boolean[] leftAlignColumn = new boolean[]{true, true};

    @Override
    public void writeValue(Writer writer, UsageReport value) throws IOException {
        writer.append(this.format(value));
    }

    private String format(UsageReport usageReport) {
        List<UsageReport.StepDefinitionUsage> stepDefinitions = usageReport.getStepDefinitions();
        List<UsageReport.StepDefinitionUsage> unusedStepDefinitions = stepDefinitions.stream().filter(stepDefinitionUsage -> stepDefinitionUsage.getMatches().isEmpty()).collect(Collectors.toList());
        StringJoiner joiner = new StringJoiner(System.lineSeparator(), System.lineSeparator(), "");
        joiner.add(unusedStepDefinitions.size() + " unused step definition(s)");
        Table table = new Table(this.headers);
        unusedStepDefinitions.forEach(entry -> {
            String source = this.sourceReferenceFormatter.format(entry.getSourceReference()).orElse("");
            String expression = entry.getExpression().getSource();
            table.add(source, "# " + expression);
        });
        if (table.getRows().size() > 1) {
            joiner.add(TableFormatter.format(table, this.leftAlignColumn));
        }
        return joiner.toString();
    }
}

