/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.workflows;

import io.dapr.durabletask.CompositeTaskFailedException;
import io.dapr.durabletask.Task;
import io.dapr.durabletask.TaskCanceledException;
import io.dapr.workflows.WorkflowTaskOptions;
import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import org.slf4j.Logger;

public interface WorkflowContext {
    public Logger getLogger();

    public String getName();

    public String getInstanceId();

    public Instant getCurrentInstant();

    public void complete(Object var1);

    public <V> Task<V> waitForExternalEvent(String var1, Duration var2, Class<V> var3) throws TaskCanceledException;

    public <V> Task<Void> waitForExternalEvent(String var1, Duration var2) throws TaskCanceledException;

    public <V> Task<Void> waitForExternalEvent(String var1) throws TaskCanceledException;

    default public <V> Task<V> waitForExternalEvent(String name, Class<V> dataType) {
        try {
            return this.waitForExternalEvent(name, null, dataType);
        }
        catch (TaskCanceledException e) {
            throw new RuntimeException("An unexpected exception was throw while waiting for an external event.", e);
        }
    }

    public <V> Task<V> callActivity(String var1, Object var2, WorkflowTaskOptions var3, Class<V> var4);

    default public Task<Void> callActivity(String name) {
        return this.callActivity(name, null, null, Void.class);
    }

    default public Task<Void> callActivity(String name, Object input) {
        return this.callActivity(name, input, null, Void.class);
    }

    default public <V> Task<V> callActivity(String name, Class<V> returnType) {
        return this.callActivity(name, null, null, returnType);
    }

    default public <V> Task<V> callActivity(String name, Object input, Class<V> returnType) {
        return this.callActivity(name, input, null, returnType);
    }

    default public Task<Void> callActivity(String name, Object input, WorkflowTaskOptions options) {
        return this.callActivity(name, input, options, Void.class);
    }

    public boolean isReplaying();

    public <V> Task<List<V>> allOf(List<Task<V>> var1) throws CompositeTaskFailedException;

    public Task<Task<?>> anyOf(List<Task<?>> var1);

    default public Task<Task<?>> anyOf(Task<?> ... tasks) {
        return this.anyOf(Arrays.asList(tasks));
    }

    public Task<Void> createTimer(Duration var1);

    public Task<Void> createTimer(ZonedDateTime var1);

    public <V> V getInput(Class<V> var1);

    default public Task<Void> callChildWorkflow(String name) {
        return this.callChildWorkflow(name, null);
    }

    default public Task<Void> callChildWorkflow(String name, Object input) {
        return this.callChildWorkflow(name, input, null);
    }

    default public <V> Task<V> callChildWorkflow(String name, Object input, Class<V> returnType) {
        return this.callChildWorkflow(name, input, null, returnType);
    }

    default public <V> Task<V> callChildWorkflow(String name, Object input, String instanceID, Class<V> returnType) {
        return this.callChildWorkflow(name, input, instanceID, null, returnType);
    }

    default public Task<Void> callChildWorkflow(String name, Object input, String instanceID, WorkflowTaskOptions options) {
        return this.callChildWorkflow(name, input, instanceID, options, Void.class);
    }

    public <V> Task<V> callChildWorkflow(String var1, @Nullable Object var2, @Nullable String var3, @Nullable WorkflowTaskOptions var4, Class<V> var5);

    default public void continueAsNew(Object input) {
        this.continueAsNew(input, true);
    }

    public void continueAsNew(Object var1, boolean var2);

    default public UUID newUuid() {
        throw new RuntimeException("No implementation found.");
    }

    public void setCustomStatus(Object var1);
}

