/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.workflows.runtime;

import io.dapr.durabletask.OrchestrationRuntimeStatus;
import io.dapr.workflows.client.WorkflowRuntimeStatus;

public class WorkflowRuntimeStatusConverter {
    private WorkflowRuntimeStatusConverter() {
    }

    public static WorkflowRuntimeStatus fromOrchestrationRuntimeStatus(OrchestrationRuntimeStatus status) {
        if (status == null) {
            throw new IllegalArgumentException("status cannot be null");
        }
        switch (status) {
            case RUNNING: {
                return WorkflowRuntimeStatus.RUNNING;
            }
            case COMPLETED: {
                return WorkflowRuntimeStatus.COMPLETED;
            }
            case CONTINUED_AS_NEW: {
                return WorkflowRuntimeStatus.CONTINUED_AS_NEW;
            }
            case FAILED: {
                return WorkflowRuntimeStatus.FAILED;
            }
            case CANCELED: {
                return WorkflowRuntimeStatus.CANCELED;
            }
            case TERMINATED: {
                return WorkflowRuntimeStatus.TERMINATED;
            }
            case PENDING: {
                return WorkflowRuntimeStatus.PENDING;
            }
            case SUSPENDED: {
                return WorkflowRuntimeStatus.SUSPENDED;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown status value: %s", status));
    }
}

