/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.client;

import io.dapr.client.DaprHttp;
import io.dapr.config.Properties;
import java.net.http.HttpClient;
import java.time.Duration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class DaprHttpBuilder {
    private static volatile HttpClient HTTP_CLIENT;
    private static final Object LOCK;

    public DaprHttp build(Properties properties) {
        return this.buildDaprHttp(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DaprHttp buildDaprHttp(Properties properties) {
        if (HTTP_CLIENT == null) {
            Object object = LOCK;
            synchronized (object) {
                if (HTTP_CLIENT == null) {
                    int maxRequests = properties.getValue(Properties.HTTP_CLIENT_MAX_REQUESTS);
                    ExecutorService executor = Executors.newFixedThreadPool(maxRequests);
                    HTTP_CLIENT = HttpClient.newBuilder().executor(executor).version(HttpClient.Version.HTTP_1_1).build();
                }
            }
        }
        String endpoint = properties.getValue(Properties.HTTP_ENDPOINT);
        String apiToken = properties.getValue(Properties.API_TOKEN);
        Duration readTimeout = Duration.ofSeconds(properties.getValue(Properties.HTTP_CLIENT_READ_TIMEOUT_SECONDS).intValue());
        if (endpoint != null && !endpoint.isEmpty()) {
            return new DaprHttp(endpoint, apiToken, readTimeout, HTTP_CLIENT);
        }
        String sidecarIp = properties.getValue(Properties.SIDECAR_IP);
        int port = properties.getValue(Properties.HTTP_PORT);
        return new DaprHttp(sidecarIp, port, apiToken, readTimeout, HTTP_CLIENT);
    }

    static {
        LOCK = new Object();
    }
}

