/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.client.domain;

import java.util.Collections;
import java.util.Map;

public final class BulkPublishEntry<T> {
    private final String entryId;
    private final T event;
    private final String contentType;
    private final Map<String, String> metadata;

    public BulkPublishEntry(String entryId, T event, String contentType) {
        this.entryId = entryId;
        this.event = event;
        this.contentType = contentType;
        this.metadata = Map.of();
    }

    public BulkPublishEntry(String entryId, T event, String contentType, Map<String, String> metadata) {
        this.entryId = entryId;
        this.event = event;
        this.contentType = contentType;
        this.metadata = metadata == null ? Map.of() : Collections.unmodifiableMap(metadata);
    }

    public String getEntryId() {
        return this.entryId;
    }

    public T getEvent() {
        return this.event;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }
}

