/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.exceptions;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import io.grpc.Status;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class DaprError {
    private String errorCode;
    private String message;
    private Integer code;
    private List<Map<String, Object>> details;

    public String getErrorCode() {
        if (this.errorCode == null && this.code != null) {
            return Status.fromCodeValue((int)this.code).getCode().name();
        }
        return this.errorCode;
    }

    public DaprError setErrorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public DaprError setMessage(String message) {
        this.message = message;
        return this;
    }

    public List<Map<String, Object>> getDetails() {
        return this.details;
    }

    public DaprError setDetails(List<Map<String, Object>> details) {
        this.details = Collections.unmodifiableList(details);
        return this;
    }
}

