/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.exceptions;

import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.rpc.BadRequest;
import com.google.rpc.DebugInfo;
import com.google.rpc.ErrorInfo;
import com.google.rpc.Help;
import com.google.rpc.LocalizedMessage;
import com.google.rpc.PreconditionFailure;
import com.google.rpc.QuotaFailure;
import com.google.rpc.RequestInfo;
import com.google.rpc.ResourceInfo;
import com.google.rpc.RetryInfo;
import com.google.rpc.Status;
import io.dapr.utils.TypeRef;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class DaprErrorDetails {
    static final DaprErrorDetails EMPTY_INSTANCE = new DaprErrorDetails((Status)null);
    private static final Map<Class<? extends Message>, ErrorDetailType> SUPPORTED_ERROR_TYPES = Map.of(ErrorInfo.class, ErrorDetailType.ERROR_INFO, RetryInfo.class, ErrorDetailType.RETRY_INFO, DebugInfo.class, ErrorDetailType.DEBUG_INFO, QuotaFailure.class, ErrorDetailType.QUOTA_FAILURE, PreconditionFailure.class, ErrorDetailType.PRECONDITION_FAILURE, BadRequest.class, ErrorDetailType.BAD_REQUEST, RequestInfo.class, ErrorDetailType.REQUEST_INFO, ResourceInfo.class, ErrorDetailType.RESOURCE_INFO, Help.class, ErrorDetailType.HELP, LocalizedMessage.class, ErrorDetailType.LOCALIZED_MESSAGE);
    private static final Map<String, Class<? extends Message>> ERROR_TYPES_FQN_REVERSE_LOOKUP = SUPPORTED_ERROR_TYPES.keySet().stream().collect(Collectors.toMap(item -> DaprErrorDetails.generateErrorTypeFqn(item), item -> item));
    private final Map<ErrorDetailType, Map<String, Object>> map;

    public DaprErrorDetails(Status grpcStatus) {
        this.map = DaprErrorDetails.parse(grpcStatus);
    }

    public DaprErrorDetails(List<Map<String, Object>> entries) {
        this.map = DaprErrorDetails.parse(entries);
    }

    public <T> T get(ErrorDetailType errorDetailType, String errAttribute, TypeRef<T> typeRef) {
        Map<String, Object> dictionary = this.map.get((Object)errorDetailType);
        if (dictionary == null) {
            return null;
        }
        return (T)dictionary.get(errAttribute);
    }

    private static Map<ErrorDetailType, Map<String, Object>> parse(Status status) {
        if (status == null || status.getDetailsList() == null) {
            return Collections.emptyMap();
        }
        HashMap<ErrorDetailType, Map<String, Object>> detailsList = new HashMap<ErrorDetailType, Map<String, Object>>();
        List grpcDetailsList = status.getDetailsList();
        for (Any detail : grpcDetailsList) {
            for (Map.Entry<Class<? extends Message>, ErrorDetailType> supportedClazzAndType : SUPPORTED_ERROR_TYPES.entrySet()) {
                Class<? extends Message> clazz = supportedClazzAndType.getKey();
                ErrorDetailType errorDetailType = supportedClazzAndType.getValue();
                if (!detail.is(clazz)) continue;
                detailsList.put(errorDetailType, DaprErrorDetails.parseProtoMessage(detail, clazz));
            }
        }
        return Collections.unmodifiableMap(detailsList);
    }

    private static Map<ErrorDetailType, Map<String, Object>> parse(List<Map<String, Object>> entries) {
        if (entries == null || entries.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<ErrorDetailType, Map<String, Object>> detailsList = new HashMap<ErrorDetailType, Map<String, Object>>();
        for (Map<String, Object> entry : entries) {
            ErrorDetailType errorDetailType;
            Class<? extends Message> clazz;
            Object type = entry.getOrDefault("@type", "");
            if (type == null || (clazz = ERROR_TYPES_FQN_REVERSE_LOOKUP.get(type.toString())) == null || (errorDetailType = SUPPORTED_ERROR_TYPES.get(clazz)) == null) continue;
            detailsList.put(errorDetailType, entry);
        }
        return Collections.unmodifiableMap(detailsList);
    }

    private static <T extends Message> Map<String, Object> parseProtoMessage(Any detail, Class<T> clazz) {
        try {
            Message message = detail.unpack(clazz);
            return DaprErrorDetails.messageToMap(message);
        }
        catch (InvalidProtocolBufferException e) {
            return Collections.singletonMap(((Object)((Object)e)).getClass().getSimpleName(), e.getMessage());
        }
    }

    private static Map<String, Object> messageToMap(Message message) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Field[] fields = message.getClass().getDeclaredFields();
        result.put("@type", DaprErrorDetails.generateErrorTypeFqn(message.getClass()));
        for (Field field : fields) {
            if (field.isSynthetic() || Modifier.isStatic(field.getModifiers())) continue;
            String normalizedFieldName = field.getName().replaceAll("_$", "");
            try {
                field.setAccessible(true);
                Object value = field.get(message);
                result.put(normalizedFieldName, value);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return Collections.unmodifiableMap(result);
    }

    private static <T extends Message> String generateErrorTypeFqn(Class<T> clazz) {
        String className = clazz.getName();
        return "type.googleapis.com/" + (className.startsWith("com.") ? className.substring(4) : className);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DaprErrorDetails that = (DaprErrorDetails)o;
        return Objects.equals(this.map, that.map);
    }

    public int hashCode() {
        return Objects.hash(this.map);
    }

    public static enum ErrorDetailType {
        ERROR_INFO,
        RETRY_INFO,
        DEBUG_INFO,
        QUOTA_FAILURE,
        PRECONDITION_FAILURE,
        BAD_REQUEST,
        REQUEST_INFO,
        RESOURCE_INFO,
        HELP,
        LOCALIZED_MESSAGE;

    }
}

