/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.internal.grpc.interceptors;

import io.dapr.internal.resiliency.TimeoutPolicy;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.MethodDescriptor;

public class DaprTimeoutInterceptor
implements ClientInterceptor {
    private final TimeoutPolicy timeoutPolicy;

    public DaprTimeoutInterceptor(TimeoutPolicy timeoutPolicy) {
        this.timeoutPolicy = timeoutPolicy;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> methodDescriptor, CallOptions options, Channel channel) {
        if (this.timeoutPolicy == null) {
            return channel.newCall(methodDescriptor, options);
        }
        return channel.newCall(methodDescriptor, this.timeoutPolicy.apply(options));
    }
}

