/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.durabletask;

import com.google.protobuf.StringValue;
import io.dapr.durabletask.implementation.protobuf.OrchestratorService;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class FailureDetails {
    private final String errorType;
    private final String errorMessage;
    private final String stackTrace;
    private final boolean isNonRetriable;

    FailureDetails(String errorType, @Nullable String errorMessage, @Nullable String errorDetails, boolean isNonRetriable) {
        this.errorType = errorType;
        this.stackTrace = errorDetails;
        this.errorMessage = errorMessage != null ? errorMessage : "";
        this.isNonRetriable = isNonRetriable;
    }

    FailureDetails(Exception exception) {
        this(exception.getClass().getName(), exception.getMessage(), FailureDetails.getFullStackTrace(exception), false);
    }

    FailureDetails(OrchestratorService.TaskFailureDetails proto) {
        this(proto.getErrorType(), proto.getErrorMessage(), proto.getStackTrace().getValue(), proto.getIsNonRetriable());
    }

    @Nonnull
    public String getErrorType() {
        return this.errorType;
    }

    @Nonnull
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Nullable
    public String getStackTrace() {
        return this.stackTrace;
    }

    public boolean isNonRetriable() {
        return this.isNonRetriable;
    }

    public boolean isCausedBy(Class<? extends Exception> exceptionClass) {
        String actualClassName = this.getErrorType();
        try {
            Class<?> actualExceptionClass = Class.forName(actualClassName);
            return exceptionClass.isAssignableFrom(actualExceptionClass);
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    static String getFullStackTrace(Throwable e) {
        StackTraceElement[] elements = e.getStackTrace();
        StringBuilder sb = new StringBuilder(elements.length * 256);
        for (StackTraceElement element : elements) {
            sb.append("\tat ").append(element.toString()).append(System.lineSeparator());
        }
        return sb.toString();
    }

    OrchestratorService.TaskFailureDetails toProto() {
        return OrchestratorService.TaskFailureDetails.newBuilder().setErrorType(this.getErrorType()).setErrorMessage(this.getErrorMessage()).setStackTrace(StringValue.of((String)(this.getStackTrace() != null ? this.getStackTrace() : ""))).build();
    }
}

