/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.durabletask;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import io.dapr.durabletask.DataConverter;

public final class JacksonDataConverter
implements DataConverter {
    private static final ObjectMapper jsonObjectMapper = ((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).build();

    @Override
    public String serialize(Object value) {
        if (value == null) {
            return null;
        }
        try {
            return jsonObjectMapper.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new DataConverter.DataConverterException(String.format("Failed to serialize argument of type '%s'. Detailed error message: %s", value.getClass().getName(), e.getMessage()), e);
        }
    }

    @Override
    public <T> T deserialize(String jsonText, Class<T> targetType) {
        if (jsonText == null || jsonText.length() == 0 || targetType == Void.class) {
            return null;
        }
        try {
            return (T)jsonObjectMapper.readValue(jsonText, targetType);
        }
        catch (JsonProcessingException e) {
            throw new DataConverter.DataConverterException(String.format("Failed to deserialize the JSON text to %s. Detailed error message: %s", targetType.getName(), e.getMessage()), e);
        }
    }
}

