/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.durabletask;

import io.dapr.durabletask.FailureDetails;

public class TaskFailedException
extends RuntimeException {
    private final FailureDetails details;
    private final String taskName;
    private final int taskId;

    TaskFailedException(String taskName, int taskId, FailureDetails details) {
        this(TaskFailedException.getExceptionMessage(taskName, taskId, details), taskName, taskId, details);
    }

    TaskFailedException(String message, String taskName, int taskId, FailureDetails details) {
        super(message);
        this.taskName = taskName;
        this.taskId = taskId;
        this.details = details;
    }

    public int getTaskId() {
        return this.taskId;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public FailureDetails getErrorDetails() {
        return this.details;
    }

    private static String getExceptionMessage(String taskName, int taskId, FailureDetails details) {
        return String.format("Task '%s' (#%d) failed with an unhandled exception: %s", taskName, taskId, details.getErrorMessage());
    }
}

