/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.binlog.jdbc;

import io.debezium.DebeziumException;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.binlog.BinlogConnectorConfig;
import io.debezium.connector.binlog.BinlogOffsetContext;
import io.debezium.connector.binlog.BinlogSourceInfo;
import io.debezium.connector.binlog.gtid.GtidSet;
import io.debezium.connector.binlog.jdbc.BinlogFieldReader;
import io.debezium.connector.binlog.jdbc.ConnectionConfiguration;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import io.debezium.relational.Column;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.util.Strings;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BinlogConnectorConnection
extends JdbcConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(BinlogConnectorConnection.class);
    private static final String SQL_SHOW_SYSTEM_VARIABLES = "SHOW VARIABLES";
    private static final String SQL_SHOW_SYSTEM_VARIABLES_CHARACTER_SET = "SHOW VARIABLES WHERE Variable_name IN ('character_set_server','collation_server')";
    private static final String SQL_SHOW_SESSION_VARIABLE_SSL_VERSION = "SHOW SESSION STATUS LIKE 'Ssl_version'";
    private static final String QUOTED_CHARACTER = "`";
    private final ConnectionConfiguration connectionConfig;
    private final BinlogFieldReader fieldReader;

    public BinlogConnectorConnection(ConnectionConfiguration configuration, BinlogFieldReader fieldReader) {
        super(configuration.config(), configuration.factory(), QUOTED_CHARACTER, QUOTED_CHARACTER);
        this.connectionConfig = configuration;
        this.fieldReader = fieldReader;
    }

    public Object getColumnValue(ResultSet rs, int columnIndex, Column column, Table table) throws SQLException {
        return this.fieldReader.readField(rs, columnIndex, column, table);
    }

    public String quotedTableIdString(TableId tableId) {
        return tableId.toQuotedString('`');
    }

    public String getQualifiedTableName(TableId tableId) {
        return tableId.catalog() + "." + tableId.table();
    }

    public Optional<Boolean> nullsSortLast() {
        return Optional.of(false);
    }

    public String connectionString() {
        return this.connectionString(this.connectionConfig.getUrlPattern());
    }

    public ConnectionConfiguration connectionConfig() {
        return this.connectionConfig;
    }

    public boolean userHasPrivileges(String grantName) {
        try {
            return (Boolean)this.queryAndMap("SHOW GRANTS FOR CURRENT_USER", rs -> {
                while (rs.next()) {
                    String grants = rs.getString(1);
                    LOGGER.debug(grants);
                    if (grants == null) {
                        return false;
                    }
                    if (!(grants = grants.toUpperCase()).contains("ALL") && !grants.contains(grantName.toUpperCase())) continue;
                    return true;
                }
                return false;
            });
        }
        catch (SQLException e) {
            throw new DebeziumException("Unexpected error while connecting to database and looking at privileges for current user: ", (Throwable)e);
        }
    }

    public String earliestBinlogFilename() {
        ArrayList logNames = new ArrayList();
        try {
            LOGGER.info("Checking all known binlogs from the database");
            this.query("SHOW BINARY LOGS", rs -> {
                while (rs.next()) {
                    logNames.add(rs.getString(1));
                }
            });
        }
        catch (SQLException e) {
            throw new DebeziumException("Unexpected error while connecting to the database and looking for binary logs: ", (Throwable)e);
        }
        if (logNames.isEmpty()) {
            return null;
        }
        return (String)logNames.get(0);
    }

    public List<String> availableBinlogFiles() {
        ArrayList<String> logNames = new ArrayList<String>();
        try {
            LOGGER.info("Get all known binlogs");
            this.query("SHOW BINARY LOGS", rs -> {
                while (rs.next()) {
                    logNames.add(rs.getString(1));
                }
            });
            return logNames;
        }
        catch (SQLException e) {
            throw new DebeziumException("Unexpected error while connecting to the database and looking for binary logs: ", (Throwable)e);
        }
    }

    public List<String> availableDatabases() {
        ArrayList<String> databaseNames = new ArrayList<String>();
        try {
            this.query("SHOW DATABASES", rs -> {
                while (rs.next()) {
                    databaseNames.add(rs.getString(1));
                }
            });
            return databaseNames;
        }
        catch (SQLException e) {
            throw new DebeziumException("Unexpected error while getting available databases: ", (Throwable)e);
        }
    }

    public OptionalLong getEstimatedTableSize(TableId tableId) {
        try {
            this.execute(new String[]{"USE `" + tableId.catalog() + "`;"});
            return (OptionalLong)this.queryAndMap("SHOW TABLE STATUS LIKE '" + tableId.table() + "';", rs -> {
                if (rs.next()) {
                    return OptionalLong.of(rs.getLong(5));
                }
                return OptionalLong.empty();
            });
        }
        catch (SQLException e) {
            LOGGER.debug("Error while getting number of rows in table {}: {}", new Object[]{tableId, e.getMessage(), e});
            return OptionalLong.empty();
        }
    }

    public Map<String, String> readCharsetSystemVariables() {
        LOGGER.debug("Reading charset-related system variables before parsing DDL history.");
        return this.querySystemVariables(SQL_SHOW_SYSTEM_VARIABLES_CHARACTER_SET);
    }

    public String setStatementFor(Map<String, String> variables) {
        StringBuilder sb = new StringBuilder("SET ");
        boolean first = true;
        ArrayList<String> varNames = new ArrayList<String>(variables.keySet());
        Collections.sort(varNames);
        for (String varName : varNames) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(varName).append("=");
            Object value = variables.get(varName);
            if (value == null) {
                value = "";
            }
            if (((String)value).contains(",") || ((String)value).contains(";")) {
                value = "'" + (String)value + "'";
            }
            sb.append((String)value);
        }
        return sb.append(";").toString();
    }

    public boolean isBinlogRowImageFull() {
        try {
            String rowImage = (String)this.queryAndMap("SHOW GLOBAL VARIABLES LIKE 'binlog_row_image'", rs -> {
                if (rs.next()) {
                    return rs.getString(2);
                }
                return "FULL";
            });
            LOGGER.debug("binlog_row_image={}", (Object)rowImage);
            return "FULL".equalsIgnoreCase(rowImage);
        }
        catch (SQLException e) {
            throw new DebeziumException("Unexpected error while connecting to the database and looking at BINLOG_ROW_IMAGE mode: ", (Throwable)e);
        }
    }

    public boolean isBinlogFormatRow() {
        try {
            String mode = (String)this.queryAndMap("SHOW GLOBAL VARIABLES LIKE 'binlog_format'", rs -> rs.next() ? rs.getString(2) : "");
            LOGGER.debug("binlog_format={}", (Object)mode);
            return "ROW".equalsIgnoreCase(mode);
        }
        catch (SQLException e) {
            throw new DebeziumException("Unexpected error while connecting to the database and looking at BINLOG_FORMAT mode: ", (Throwable)e);
        }
    }

    public Map<String, DatabaseLocales> readDatabaseCollations() {
        LOGGER.debug("Reading default database charsets");
        try {
            return (Map)this.queryAndMap("SELECT schema_name, default_character_set_name, default_collation_name FROM information_schema.schemata", rs -> {
                HashMap<String, DatabaseLocales> charsets = new HashMap<String, DatabaseLocales>();
                while (rs.next()) {
                    String databaseName = rs.getString(1);
                    String characterSet = rs.getString(2);
                    String collationName = rs.getString(3);
                    if (databaseName == null || characterSet == null && collationName == null) continue;
                    charsets.put(databaseName, new DatabaseLocales(characterSet, collationName));
                    LOGGER.debug("\t{} = {}, {}", new Object[]{Strings.pad((String)databaseName, (int)45, (char)' '), Strings.pad((String)characterSet, (int)45, (char)' '), Strings.pad((String)collationName, (int)45, (char)' ')});
                }
                return charsets;
            });
        }
        catch (SQLException e) {
            throw new DebeziumException("Error reading default database charsets: " + e.getMessage(), (Throwable)e);
        }
    }

    public boolean isTableIdCaseSensitive() {
        return !"0".equals(this.readSystemVariables().get("lower_case_table_names"));
    }

    public boolean isBinlogPositionAvailable(BinlogConnectorConfig config, String gtid, String binlogFileName) {
        if (gtid != null) {
            if (gtid.trim().isEmpty()) {
                return true;
            }
            GtidSet availableGtidSet = this.knownGtidSet();
            if (availableGtidSet.isEmpty()) {
                LOGGER.info("Connector used GTIDs previously, but server does not know of any GTIDs or they are not enabled");
                return false;
            }
            GtidSet gtidSet = config.getGtidSetFactory().createGtidSet(gtid).retainAll(config.getGtidSourceFilter());
            LOGGER.info("GTID Set retained: '{}'", (Object)gtidSet);
            if (gtidSet.isContainedWithin(availableGtidSet)) {
                LOGGER.info("The current GTID set '{}' does not contain the GTID set '{}' required by the connector", (Object)availableGtidSet, (Object)gtidSet);
                GtidSet knownServerSet = availableGtidSet.retainAll(config.getGtidSourceFilter());
                GtidSet gtidSetToReplicate = this.subtractGtidSet(knownServerSet, gtidSet);
                GtidSet purgedGtidSet = this.purgedGtidSet();
                LOGGER.info("Server has already purged '{}' GTIDs", (Object)purgedGtidSet);
                GtidSet nonPurgedGtidSetTemplate = this.subtractGtidSet(gtidSetToReplicate, purgedGtidSet);
                LOGGER.info("GTIDs known by the server but not processed yet '{}', for replication are available only '{}'", (Object)gtidSetToReplicate, (Object)nonPurgedGtidSetTemplate);
                if (!gtidSetToReplicate.equals(nonPurgedGtidSetTemplate)) {
                    LOGGER.info("Some of the GTIDs needed to replicate have been already purged");
                    return false;
                }
                return true;
            }
            LOGGER.info("Connector last known GTIDs are '{}', but server has '{}'", (Object)gtidSet, (Object)availableGtidSet);
            return false;
        }
        if (Strings.isNullOrBlank((String)binlogFileName)) {
            return true;
        }
        List<String> logNames = this.availableBinlogFiles();
        boolean found = logNames.stream().anyMatch(binlogFileName::equals);
        if (!found && LOGGER.isInfoEnabled()) {
            LOGGER.info("Connector requires binlog file '{}', but server only has {}", (Object)binlogFileName, (Object)String.join((CharSequence)", ", logNames));
        } else if (found && LOGGER.isInfoEnabled()) {
            LOGGER.info("Server has the binlog file '{}' required by the connector", (Object)binlogFileName);
        }
        return found;
    }

    public String getSessionVariableForSslVersion() {
        String SSL_VERSION = "Ssl_version";
        LOGGER.debug("Reading session variable for Ssl Version");
        Map<String, String> sessionVariables = this.querySystemVariables(SQL_SHOW_SESSION_VARIABLE_SSL_VERSION);
        if (!sessionVariables.isEmpty() && sessionVariables.containsKey("Ssl_version")) {
            return sessionVariables.get("Ssl_version");
        }
        return null;
    }

    public boolean validateLogPosition(Partition partition, OffsetContext offset, CommonConnectorConfig config) {
        String gtidSet = ((BinlogOffsetContext)offset).gtidSet();
        String binlogFilename = ((BinlogSourceInfo)((Object)((BinlogOffsetContext)offset).getSource())).binlogFilename();
        return this.isBinlogPositionAvailable((BinlogConnectorConfig)config, gtidSet, binlogFilename);
    }

    public abstract boolean isGtidModeEnabled();

    public abstract GtidSet knownGtidSet();

    public abstract GtidSet subtractGtidSet(GtidSet var1, GtidSet var2);

    public abstract GtidSet purgedGtidSet();

    public abstract GtidSet filterGtidSet(Predicate<String> var1, String var2, GtidSet var3, GtidSet var4);

    protected Map<String, String> readSystemVariables() {
        LOGGER.debug("Reading system variables");
        return this.querySystemVariables(SQL_SHOW_SYSTEM_VARIABLES);
    }

    private Map<String, String> querySystemVariables(String statement) {
        HashMap<String, String> variables = new HashMap<String, String>();
        try {
            this.query(statement, rs -> {
                while (rs.next()) {
                    String varName = rs.getString(1);
                    String value = rs.getString(2);
                    if (varName == null || value == null) continue;
                    variables.put(varName, value);
                    LOGGER.debug("\t{} = {}", (Object)Strings.pad((String)varName, (int)45, (char)' '), (Object)Strings.pad((String)value, (int)45, (char)' '));
                }
            });
        }
        catch (SQLException e) {
            throw new DebeziumException("Error reading MySQL variables: " + e.getMessage(), (Throwable)e);
        }
        return variables;
    }

    public static class DatabaseLocales {
        private final String charset;
        private final String collation;

        public DatabaseLocales(String charset, String collation) {
            this.charset = charset;
            this.collation = collation;
        }

        public void appendToDdlStatement(String dbName, StringBuilder ddl) {
            if (this.charset != null) {
                LOGGER.debug("Setting default charset '{}' for database '{}'", (Object)this.charset, (Object)dbName);
                ddl.append(" CHARSET ").append(this.charset);
            } else {
                LOGGER.info("Default database charset for '{}' not found", (Object)dbName);
            }
            if (this.collation != null) {
                LOGGER.debug("Setting default collation '{}' for database '{}'", (Object)this.collation, (Object)dbName);
                ddl.append(" COLLATE ").append(this.collation);
            } else {
                LOGGER.info("Default database collation for '{}' not found", (Object)dbName);
            }
        }
    }
}

