/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.binlog;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.ConfigDefinition;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.config.Field;
import io.debezium.connector.binlog.gtid.GtidSetFactory;
import io.debezium.jdbc.JdbcValueConverters;
import io.debezium.jdbc.TemporalPrecisionMode;
import io.debezium.relational.ColumnFilterMode;
import io.debezium.relational.HistorizedRelationalDatabaseConnectorConfig;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.schema.DefaultTopicNamingStrategy;
import io.debezium.util.Collect;
import java.time.Duration;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.source.SourceConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BinlogConnectorConfig
extends HistorizedRelationalDatabaseConnectorConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(BinlogConnectorConfig.class);
    static final String TEST_DISABLE_GLOBAL_LOCKING = "test.disable.global.locking";
    protected static final Set<String> BUILT_IN_DB_NAMES = Collect.unmodifiableSet((Object[])new String[]{"mysql", "performance_schema", "sys", "information_schema"});
    private static final int DEFAULT_PORT = 3306;
    private static final int DEFAULT_BINLOG_BUFFER_SIZE = 0;
    public static final Field PORT = RelationalDatabaseConnectorConfig.PORT.withDefault(3306);
    public static final Field TABLES_IGNORE_BUILTIN = RelationalDatabaseConnectorConfig.TABLE_IGNORE_BUILTIN.withDependents(new String[]{"database.include.list"});
    public static final Field STORE_ONLY_CAPTURED_DATABASES_DDL = HistorizedRelationalDatabaseConnectorConfig.STORE_ONLY_CAPTURED_DATABASES_DDL.withDefault(true);
    public static final Field ON_CONNECT_STATEMENTS = Field.create((String)"database.initial.statements").withDisplayName("Initial statements").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.LOW).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED, (int)4)).withDescription("A semicolon separated list of SQL statements to be executed when a JDBC connection (not binlog reading connection) to the database is established. Note that the connector may establish JDBC connections at its own discretion, so this should typically be used for configuration of session parameters only, but not for executing DML statements. Use doubled semicolon (';;') to use a semicolon as a character and not as a delimiter.");
    public static final Field SERVER_ID = Field.create((String)"database.server.id").withDisplayName("Cluster ID").withType(ConfigDef.Type.LONG).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.HIGH).required().withValidation(new Field.Validator[]{Field::isPositiveLong}).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION, (int)1)).withDescription("A numeric ID of this database client, which must be unique across all currently-running database processes in the cluster. This connector joins the database cluster as another server (with this unique ID) so it can read the binlog.");
    public static final Field SERVER_ID_OFFSET = Field.create((String)"database.server.id.offset").withDisplayName("Cluster ID offset").withType(ConfigDef.Type.LONG).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.HIGH).withDefault(10000L).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED, (int)0)).withDescription("Only relevant if parallel snapshotting is configured. During parallel snapshotting, multiple (4) connections open to the database client, and they each need their own unique connection ID. This offset is used to generate those IDs from the base configured cluster ID.");
    public static final Field SSL_MODE = Field.create((String)"database.ssl.mode").withDisplayName("SSL mode").withEnum(SecureConnectionMode.class, (Enum)SecureConnectionMode.PREFERRED).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.MEDIUM).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED_SSL, (int)0)).withDescription("Whether to use an encrypted connection to the database. Options include: 'disabled' to use an unencrypted connection; 'preferred' (the default) to establish a secure (encrypted) connection if the server supports secure connections, but fall back to an unencrypted connection otherwise; 'required' to use a secure (encrypted) connection, and fail if one cannot be established; 'verify_ca' like 'required' but additionally verify the server TLS certificate against the configured Certificate Authority (CA) certificates, or fail if no valid matching CA certificates are found; or 'verify_identity' like 'verify_ca' but additionally verify that the server certificate matches the host to which the connection is attempted.");
    public static final Field SSL_KEYSTORE = Field.create((String)"database.ssl.keystore").withDisplayName("SSL Keystore").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED_SSL, (int)1)).withDescription("The location of the key store file. This is optional and can be used for two-way authentication between the client and the database.");
    public static final Field SSL_KEYSTORE_PASSWORD = Field.create((String)"database.ssl.keystore.password").withDisplayName("SSL Keystore Password").withType(ConfigDef.Type.PASSWORD).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.MEDIUM).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED_SSL, (int)2)).withDescription("The password for the key store file. This is optional and only needed if 'database.ssl.keystore' is configured.");
    public static final Field SSL_TRUSTSTORE = Field.create((String)"database.ssl.truststore").withDisplayName("SSL Truststore").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED_SSL, (int)3)).withDescription("The location of the trust store file for the server certificate verification.");
    public static final Field SSL_TRUSTSTORE_PASSWORD = Field.create((String)"database.ssl.truststore.password").withDisplayName("SSL Truststore Password").withType(ConfigDef.Type.PASSWORD).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.MEDIUM).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED_SSL, (int)4)).withDescription("The password for the trust store file. Used to check the integrity of the truststore, and unlock the truststore.");
    public static final Field CONNECTION_TIMEOUT_MS = Field.create((String)"connect.timeout.ms").withDisplayName("Connection Timeout (ms)").withType(ConfigDef.Type.INT).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDefault(30000).withValidation(new Field.Validator[]{Field::isPositiveInteger}).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED, (int)1)).withDescription("Maximum time to wait after trying to connect to the database before timing out, given in milliseconds. Defaults to 30 seconds (30,000 ms).");
    public static final Field KEEP_ALIVE = Field.create((String)"connect.keep.alive").withDisplayName("Keep connection alive (true/false)").withType(ConfigDef.Type.BOOLEAN).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(true).withValidation(new Field.Validator[]{Field::isBoolean}).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED, (int)2)).withDescription("Whether a separate thread should be used to ensure the connection is kept alive.");
    public static final Field KEEP_ALIVE_INTERVAL_MS = Field.create((String)"connect.keep.alive.interval.ms").withDisplayName("Keep alive interval (ms)").withType(ConfigDef.Type.LONG).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(Duration.ofMinutes(1L).toMillis()).withValidation(new Field.Validator[]{Field::isPositiveInteger}).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED, (int)3)).withDescription("Interval for connection checking if keep alive thread is used, given in milliseconds Defaults to 1 minute (60,000 ms).");
    public static final Field USE_NONGRACEFUL_DISCONNECT = Field.create((String)"use.nongraceful.disconnect").withDisplayName("Use Non-graceful Disconnect").withType(ConfigDef.Type.BOOLEAN).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED, (int)5)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDefault(false).withDescription("Whether to use `socket.setSoLinger(true, 0)` when BinaryLogClient keepalive thread triggers a disconnect for a stale connection.");
    public static final Field ROW_COUNT_FOR_STREAMING_RESULT_SETS = Field.create((String)"min.row.count.to.stream.results").withDisplayName("Stream result set of size").withType(ConfigDef.Type.INT).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.LOW).withDefault(1000).withValidation(new Field.Validator[]{Field::isNonNegativeLong}).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_ADVANCED, (int)2)).withDescription("The number of rows a table must contain to stream results rather than pull all into memory during snapshots. Defaults to 1,000. Use 0 to stream all results and completely avoid checking the size of each table.");
    public static final Field BUFFER_SIZE_FOR_BINLOG_READER = Field.create((String)"binlog.buffer.size").withDisplayName("Binlog reader buffer size").withType(ConfigDef.Type.INT).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.MEDIUM).withDefault(0).withValidation(new Field.Validator[]{Field::isNonNegativeInteger}).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_ADVANCED, (int)3)).withDescription("The size of a look-ahead buffer used by the binlog reader to decide whether the transaction in progress is going to be committed or rolled back. Use 0 to disable look-ahead buffering. Defaults to 0 (i.e. buffering is disabled.");
    public static final Field TOPIC_NAMING_STRATEGY = Field.create((String)"topic.naming.strategy").withDisplayName("Topic naming strategy class").withType(ConfigDef.Type.CLASS).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.MEDIUM).withDefault(DefaultTopicNamingStrategy.class.getName()).withDescription("The name of the TopicNamingStrategy class that should be used to determine the topic name for data change, schema change, transaction, heartbeat event etc.");
    public static final Field INCLUDE_SQL_QUERY = Field.create((String)"include.query").withDisplayName("Include original SQL query with in change events").withType(ConfigDef.Type.BOOLEAN).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDefault(false).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_ADVANCED, (int)0)).withDescription("Whether the connector should include the original SQL query that generated the change event. Note: This option requires the database to be configured using the server option binlog_rows_query_log_events (MySQL) or binlog_annotate_row_events (MariaDB) set to ON.Query will not be present for events generated from snapshot. WARNING: Enabling this option may expose tables or fields explicitly excluded or masked by including the original SQL statement in the change event. For this reason the default value is 'false'.");
    public static final Field SNAPSHOT_MODE = Field.create((String)"snapshot.mode").withDisplayName("Snapshot mode").withEnum(SnapshotMode.class, (Enum)SnapshotMode.INITIAL).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_SNAPSHOT, (int)0)).withDescription("The criteria for running a snapshot upon startup of the connector. Select one of the following snapshot options: 'when_needed': On startup, the connector runs a snapshot if one is needed.; 'schema_only': If the connector does not detect any offsets for the logical server name, it runs a snapshot that captures only the schema (table structures), but not any table data. After the snapshot completes, the connector begins to stream changes from the binlog.; 'schema_only_recovery': The connector performs a snapshot that captures only the database schema history. The connector then transitions back to streaming. Use this setting to restore a corrupted or lost database schema history topic. Do not use if the database schema was modified after the connector stopped.; 'initial' (default): If the connector does not detect any offsets for the logical server name, it runs a snapshot that captures the current full state of the configured tables. After the snapshot completes, the connector begins to stream changes from the binlog.; 'initial_only': The connector performs a snapshot as it does for the 'initial' option, but after the connector completes the snapshot, it stops, and does not stream changes from the binlog.; 'never': The connector does not run a snapshot. Upon first startup, the connector immediately begins reading from the beginning of the binlog. The 'never' mode should be used with care, and only when the binlog is known to contain all history.");
    public static final Field TIME_PRECISION_MODE = RelationalDatabaseConnectorConfig.TIME_PRECISION_MODE.withDisplayName("The time precision mode to be used").withEnum(TemporalPrecisionMode.class, (Enum)TemporalPrecisionMode.ADAPTIVE_TIME_MICROSECONDS).withValidation(new Field.Validator[]{BinlogConnectorConfig::validateTimePrecisionMode}).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)26)).withDescription("Time, date and timestamps can be represented with different kinds of precisions, including: 'adaptive_time_microseconds': the precision of date and timestamp values is based the database column's precision; but time fields always use microseconds precision; 'connect': always represents time, date and timestamp values using Kafka Connect's built-in representations for Time, Date, and Timestamp, which uses millisecond precision regardless of the database columns' precision.");
    public static final Field BIGINT_UNSIGNED_HANDLING_MODE = Field.create((String)"bigint.unsigned.handling.mode").withDisplayName("The mode for handling bigint-unsigned values").withEnum(BigIntUnsignedHandlingMode.class, (Enum)BigIntUnsignedHandlingMode.LONG).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)27)).withDescription("Specify how BIGINT UNSIGNED columns should be represented in change events, including: 'precise' uses java.math.BigDecimal to represent values, which are encoded in the change events using a binary representation and Kafka Connect's 'org.apache.kafka.connect.data.Decimal' type; 'long' (the default) represents values using Java's 'long', which may not offer the precision but will be far easier to use in consumers.");
    @Deprecated
    public static final Field EVENT_DESERIALIZATION_FAILURE_HANDLING_MODE = Field.create((String)"event.deserialization.failure.handling.mode").withDisplayName("Event deserialization failure handling").withEnum(CommonConnectorConfig.EventProcessingFailureHandlingMode.class, (Enum)CommonConnectorConfig.EventProcessingFailureHandlingMode.FAIL).withValidation(new Field.Validator[]{BinlogConnectorConfig::validateEventDeserializationFailureHandlingModeNotSet}).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)21)).withDescription("Specify how failures during deserialization of binlog events (i.e. when encountering a corrupted event) should be handled, including: 'fail' (the default) an exception indicating the problematic event and its binlog position is raised, causing the connector to be stopped; 'warn' the problematic event and its binlog position will be logged and the event will be skipped; 'ignore' the problematic event will be skipped.");
    public static final Field INCONSISTENT_SCHEMA_HANDLING_MODE = Field.create((String)"inconsistent.schema.handling.mode").withDisplayName("Inconsistent schema failure handling").withEnum(CommonConnectorConfig.EventProcessingFailureHandlingMode.class, (Enum)CommonConnectorConfig.EventProcessingFailureHandlingMode.FAIL).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withGroup(Field.createGroupEntry((Field.Group)Field.Group.ADVANCED, (int)2)).withDescription("Specify how binlog events that belong to a table missing from internal schema representation (i.e. internal representation is not consistent with database) should be handled, including: 'fail' (the default) an exception indicating the problematic event and its binlog position is raised, causing the connector to be stopped; 'warn' the problematic event and its binlog position will be logged and the event will be skipped; 'skip' the problematic event will be skipped.");
    public static final Field ENABLE_TIME_ADJUSTER = Field.create((String)"enable.time.adjuster").withDisplayName("Enable Time Adjuster").withType(ConfigDef.Type.BOOLEAN).withDefault(true).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)22)).withDescription("The database allows the user to insert year value as either 2-digit or 4-digit. In case of two digit the value is automatically mapped into 1970 - 2069.false - delegates the implicit conversion to the database; true - (the default) Debezium makes the conversion");
    public static final Field READ_ONLY_CONNECTION = Field.create((String)"read.only").withDisplayName("Read only connection").withType(ConfigDef.Type.BOOLEAN).withDefault(false).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("Switched connector to use alternative methods to deliver signals to Debezium instead of writing to signaling table");
    public static final Field GTID_SOURCE_INCLUDES = Field.create((String)"gtid.source.includes").withDisplayName("Include GTID sources").withType(ConfigDef.Type.LIST).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.HIGH).withDependents(new String[]{"table.include.list"}).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)24));
    public static final Field GTID_SOURCE_EXCLUDES = Field.create((String)"gtid.source.excludes").withDisplayName("Exclude GTID sources").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)25)).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withValidation(new Field.Validator[]{BinlogConnectorConfig::validateGtidSetExcludes}).withInvisibleRecommender().withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)25));
    public static final Field GTID_SOURCE_FILTER_DML_EVENTS = Field.create((String)"gtid.source.filter.dml.events").withDisplayName("Filter DML events").withType(ConfigDef.Type.BOOLEAN).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)23)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDefault(true).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)23)).withDescription("When set to true, only produce DML events for transactions that were written on the server with matching GTIDs defined by the `gtid.source.includes` or `gtid.source.excludes`, if they were specified.");
    protected static final ConfigDefinition CONFIG_DEFINITION = HistorizedRelationalDatabaseConnectorConfig.CONFIG_DEFINITION.edit().excluding(new Field[]{SCHEMA_INCLUDE_LIST, SCHEMA_EXCLUDE_LIST, RelationalDatabaseConnectorConfig.TIME_PRECISION_MODE, RelationalDatabaseConnectorConfig.TABLE_IGNORE_BUILTIN, HistorizedRelationalDatabaseConnectorConfig.STORE_ONLY_CAPTURED_DATABASES_DDL}).type(new Field[]{HOSTNAME, PORT, USER, PASSWORD, QUERY_TIMEOUT_MS, ON_CONNECT_STATEMENTS, SERVER_ID, SERVER_ID_OFFSET, SSL_MODE, SSL_KEYSTORE, SSL_KEYSTORE_PASSWORD, SSL_TRUSTSTORE, SSL_TRUSTSTORE_PASSWORD}).connector(new Field[]{CONNECTION_TIMEOUT_MS, KEEP_ALIVE, KEEP_ALIVE_INTERVAL_MS, USE_NONGRACEFUL_DISCONNECT, SNAPSHOT_MODE, SNAPSHOT_QUERY_MODE, SNAPSHOT_QUERY_MODE_CUSTOM_NAME, BIGINT_UNSIGNED_HANDLING_MODE, TIME_PRECISION_MODE, ENABLE_TIME_ADJUSTER, SCHEMA_NAME_ADJUSTMENT_MODE, ROW_COUNT_FOR_STREAMING_RESULT_SETS, INCREMENTAL_SNAPSHOT_CHUNK_SIZE, INCREMENTAL_SNAPSHOT_ALLOW_SCHEMA_CHANGES, STORE_ONLY_CAPTURED_DATABASES_DDL}).events(new Field[]{INCLUDE_SQL_QUERY, TABLES_IGNORE_BUILTIN, DATABASE_INCLUDE_LIST, DATABASE_EXCLUDE_LIST, BUFFER_SIZE_FOR_BINLOG_READER, EVENT_DESERIALIZATION_FAILURE_HANDLING_MODE, INCONSISTENT_SCHEMA_HANDLING_MODE, GTID_SOURCE_INCLUDES, GTID_SOURCE_EXCLUDES, GTID_SOURCE_FILTER_DML_EVENTS}).create();
    private final Configuration config;
    private final SnapshotMode snapshotMode;
    private final TemporalPrecisionMode temporalPrecisionMode;
    private final Duration connectionTimeout;
    private final CommonConnectorConfig.EventProcessingFailureHandlingMode inconsistentSchemaFailureHandlingMode;
    private final SecureConnectionMode secureConnectionMode;
    private final BigIntUnsignedHandlingMode bigIntUnsignedHandlingMode;
    private final boolean readOnlyConnection;

    public BinlogConnectorConfig(Class<? extends SourceConnector> connectorClazz, Configuration config, int defaultFetchSize) {
        super(connectorClazz, config, Tables.TableFilter.fromPredicate(BinlogConnectorConfig::isNotBuiltInTable), true, defaultFetchSize, ColumnFilterMode.CATALOG, false);
        this.config = config;
        this.temporalPrecisionMode = TemporalPrecisionMode.parse((String)config.getString(TIME_PRECISION_MODE));
        this.snapshotMode = SnapshotMode.parse(config.getString(SNAPSHOT_MODE), SNAPSHOT_MODE.defaultValueAsString());
        this.readOnlyConnection = config.getBoolean(READ_ONLY_CONNECTION);
        this.storeOnlyCapturedDatabasesDdl = config.getBoolean(STORE_ONLY_CAPTURED_DATABASES_DDL);
        this.connectionTimeout = Duration.ofMillis(config.getLong(CONNECTION_TIMEOUT_MS));
        this.inconsistentSchemaFailureHandlingMode = CommonConnectorConfig.EventProcessingFailureHandlingMode.parse((String)config.getString(INCONSISTENT_SCHEMA_HANDLING_MODE));
        this.secureConnectionMode = SecureConnectionMode.parse(config.getString(SSL_MODE));
        this.bigIntUnsignedHandlingMode = BigIntUnsignedHandlingMode.parse(config.getString(BIGINT_UNSIGNED_HANDLING_MODE));
    }

    public boolean supportsOperationFiltering() {
        return true;
    }

    protected boolean supportsSchemaChangesDuringIncrementalSnapshot() {
        return true;
    }

    public TemporalPrecisionMode getTemporalPrecisionMode() {
        return this.temporalPrecisionMode;
    }

    public EnumeratedValue getSnapshotMode() {
        return this.snapshotMode;
    }

    public Duration getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public CommonConnectorConfig.EventProcessingFailureHandlingMode getInconsistentSchemaFailureHandlingMode() {
        return this.inconsistentSchemaFailureHandlingMode;
    }

    public BigIntUnsignedHandlingMode getBigIntUnsignedHandlingMode() {
        return this.bigIntUnsignedHandlingMode;
    }

    public boolean useCursorFetch() {
        return this.getSnapshotFetchSize() > 0;
    }

    public String getHostName() {
        return this.config.getString(HOSTNAME);
    }

    public int getPort() {
        return this.config.getInteger(PORT);
    }

    public String getUserName() {
        return this.config.getString(USER);
    }

    public String getPassword() {
        return this.config.getString(PASSWORD);
    }

    public long getServerId() {
        return this.config.getInteger(SERVER_ID);
    }

    public SecureConnectionMode getSslMode() {
        return this.secureConnectionMode;
    }

    public boolean isSslModeEnabled() {
        return this.secureConnectionMode != SecureConnectionMode.DISABLED;
    }

    public int getBufferSizeForStreamingChangeEventSource() {
        return this.config.getInteger(BUFFER_SIZE_FOR_BINLOG_READER);
    }

    public boolean isSqlQueryIncluded() {
        return this.config.getBoolean(INCLUDE_SQL_QUERY);
    }

    public long getRowCountForLargeTable() {
        return this.config.getLong(ROW_COUNT_FOR_STREAMING_RESULT_SETS);
    }

    public boolean isReadOnlyConnection() {
        return this.readOnlyConnection;
    }

    public boolean isTimeAdjustedEnabled() {
        return this.config.getBoolean(ENABLE_TIME_ADJUSTER);
    }

    public abstract Predicate<String> getGtidSourceFilter();

    public abstract GtidSetFactory getGtidSetFactory();

    protected boolean isGlobalLockUseRequested() {
        return !"true".equals(this.config.getString(TEST_DISABLE_GLOBAL_LOCKING));
    }

    public static boolean isBuiltInDatabase(String databaseName) {
        if (databaseName == null) {
            return false;
        }
        return BUILT_IN_DB_NAMES.contains(databaseName.toLowerCase());
    }

    public static boolean isNotBuiltInTable(TableId tableId) {
        return !BinlogConnectorConfig.isBuiltInDatabase(tableId.catalog());
    }

    protected abstract SnapshotLockingStrategy getSnapshotLockingStrategy();

    private static int validateEventDeserializationFailureHandlingModeNotSet(Configuration config, Field field, Field.ValidationOutput problems) {
        String modeName = (String)config.asMap().get(EVENT_DESERIALIZATION_FAILURE_HANDLING_MODE.name());
        if (modeName != null) {
            LOGGER.warn("Configuration option '{}' is deprecated, use to '{}' instead.", (Object)EVENT_DESERIALIZATION_FAILURE_HANDLING_MODE.name(), (Object)EVENT_PROCESSING_FAILURE_HANDLING_MODE.name());
        }
        return 0;
    }

    private static int validateTimePrecisionMode(Configuration config, Field field, Field.ValidationOutput problems) {
        if (config.hasKey(TIME_PRECISION_MODE.name())) {
            String timePrecisionMode = config.getString(TIME_PRECISION_MODE.name());
            if (TemporalPrecisionMode.ADAPTIVE.getValue().equals(timePrecisionMode)) {
                problems.accept(TIME_PRECISION_MODE, (Object)timePrecisionMode, "The 'adaptive' time.precision.mode is no longer supported");
                return 1;
            }
        }
        return 0;
    }

    private static int validateGtidSetExcludes(Configuration config, Field field, Field.ValidationOutput problems) {
        String includes = config.getString(GTID_SOURCE_INCLUDES);
        String excludes = config.getString(GTID_SOURCE_EXCLUDES);
        if (includes != null && excludes != null) {
            problems.accept(GTID_SOURCE_EXCLUDES, (Object)excludes, "Cannot specify GTID excludes when includes are provided.");
            return 1;
        }
        return 0;
    }

    public boolean usesNonGracefulDisconnect() {
        return this.config.getBoolean(USE_NONGRACEFUL_DISCONNECT);
    }

    public static enum SnapshotMode implements EnumeratedValue
    {
        ALWAYS("always"),
        WHEN_NEEDED("when_needed"),
        INITIAL("initial"),
        SCHEMA_ONLY("schema_only"),
        NO_DATA("no_data"),
        SCHEMA_ONLY_RECOVERY("schema_only_recovery"),
        RECOVERY("recovery"),
        NEVER("never"),
        INITIAL_ONLY("initial_only"),
        CONFIGURATION_BASED("configuration_based"),
        CUSTOM("custom");

        private final String value;

        private SnapshotMode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static SnapshotMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (SnapshotMode option : SnapshotMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static SnapshotMode parse(String value, String defaultValue) {
            SnapshotMode mode = SnapshotMode.parse(value);
            if (mode == null && defaultValue != null) {
                mode = SnapshotMode.parse(defaultValue);
            }
            return mode;
        }
    }

    public static enum SecureConnectionMode implements EnumeratedValue
    {
        DISABLED("disabled"),
        PREFERRED("preferred"),
        REQUIRED("required"),
        VERIFY_CA("verify_ca"),
        VERIFY_IDENTITY("verify_identity");

        private final String value;

        private SecureConnectionMode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static SecureConnectionMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (SecureConnectionMode option : SecureConnectionMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static SecureConnectionMode parse(String value, String defaultValue) {
            SecureConnectionMode mode = SecureConnectionMode.parse(value);
            if (mode == null && defaultValue != null) {
                mode = SecureConnectionMode.parse(defaultValue);
            }
            return mode;
        }
    }

    public static enum BigIntUnsignedHandlingMode implements EnumeratedValue
    {
        PRECISE("precise"),
        LONG("long");

        private final String value;

        private BigIntUnsignedHandlingMode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static BigIntUnsignedHandlingMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (BigIntUnsignedHandlingMode option : BigIntUnsignedHandlingMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static BigIntUnsignedHandlingMode parse(String value, String defaultValue) {
            BigIntUnsignedHandlingMode mode = BigIntUnsignedHandlingMode.parse(value);
            if (mode == null && defaultValue != null) {
                mode = BigIntUnsignedHandlingMode.parse(defaultValue);
            }
            return mode;
        }

        public JdbcValueConverters.BigIntUnsignedMode asBigIntUnsignedMode() {
            switch (this.ordinal()) {
                case 1: {
                    return JdbcValueConverters.BigIntUnsignedMode.LONG;
                }
            }
            return JdbcValueConverters.BigIntUnsignedMode.PRECISE;
        }
    }

    public static interface SnapshotLockingStrategy {
        public boolean isLockingEnabled();

        public boolean isMinimalLockingEnabled();

        public boolean isIsolationLevelResetOnFlush();
    }
}

