/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.db2;

import io.debezium.connector.SnapshotRecord;
import io.debezium.connector.common.BaseSourceInfo;
import io.debezium.connector.db2.Db2ConnectorConfig;
import io.debezium.connector.db2.Lsn;
import io.debezium.connector.db2.SourceInfo;
import io.debezium.connector.db2.TxLogPosition;
import io.debezium.pipeline.CommonOffsetContext;
import io.debezium.pipeline.source.snapshot.incremental.IncrementalSnapshotContext;
import io.debezium.pipeline.source.snapshot.incremental.SignalBasedIncrementalSnapshotContext;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.txmetadata.TransactionContext;
import io.debezium.relational.TableId;
import io.debezium.spi.schema.DataCollectionId;
import io.debezium.util.Collect;
import java.time.Instant;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;

public class Db2OffsetContext
extends CommonOffsetContext<SourceInfo> {
    private static final String SERVER_PARTITION_KEY = "server";
    private static final String SNAPSHOT_COMPLETED_KEY = "snapshot_completed";
    private static final String EVENT_SERIAL_NO_KEY = "event_serial_no";
    private final Schema sourceInfoSchema;
    private boolean snapshotCompleted;
    private final TransactionContext transactionContext;
    private final IncrementalSnapshotContext<TableId> incrementalSnapshotContext;
    private long eventSerialNo;

    public Db2OffsetContext(Db2ConnectorConfig connectorConfig, TxLogPosition position, boolean snapshot, boolean snapshotCompleted, long eventSerialNo, TransactionContext transactionContext, IncrementalSnapshotContext<TableId> incrementalSnapshotContext) {
        super((BaseSourceInfo)new SourceInfo(connectorConfig));
        ((SourceInfo)this.sourceInfo).setCommitLsn(position.getCommitLsn());
        ((SourceInfo)this.sourceInfo).setChangeLsn(position.getInTxLsn());
        this.sourceInfoSchema = ((SourceInfo)this.sourceInfo).schema();
        this.snapshotCompleted = snapshotCompleted;
        if (this.snapshotCompleted) {
            this.postSnapshotCompletion();
        } else {
            ((SourceInfo)this.sourceInfo).setSnapshot(snapshot ? SnapshotRecord.TRUE : SnapshotRecord.FALSE);
        }
        this.eventSerialNo = eventSerialNo;
        this.transactionContext = transactionContext;
        this.incrementalSnapshotContext = incrementalSnapshotContext;
    }

    public Db2OffsetContext(Db2ConnectorConfig connectorConfig, TxLogPosition position, boolean snapshot, boolean snapshotCompleted) {
        this(connectorConfig, position, snapshot, snapshotCompleted, 1L, new TransactionContext(), (IncrementalSnapshotContext<TableId>)new SignalBasedIncrementalSnapshotContext(false));
    }

    public Map<String, ?> getOffset() {
        if (((SourceInfo)this.sourceInfo).isSnapshot()) {
            return Collect.hashMapOf((Object)"snapshot", (Object)true, (Object)SNAPSHOT_COMPLETED_KEY, (Object)this.snapshotCompleted, (Object)"commit_lsn", (Object)((SourceInfo)this.sourceInfo).getCommitLsn().toString());
        }
        return this.incrementalSnapshotContext.store(this.transactionContext.store(Collect.hashMapOf((Object)"commit_lsn", (Object)((SourceInfo)this.sourceInfo).getCommitLsn().toString(), (Object)"change_lsn", (Object)(((SourceInfo)this.sourceInfo).getChangeLsn() == null ? null : ((SourceInfo)this.sourceInfo).getChangeLsn().toString()), (Object)EVENT_SERIAL_NO_KEY, (Object)this.eventSerialNo)));
    }

    public Schema getSourceInfoSchema() {
        return this.sourceInfoSchema;
    }

    public TxLogPosition getChangePosition() {
        return TxLogPosition.valueOf(((SourceInfo)this.sourceInfo).getCommitLsn(), ((SourceInfo)this.sourceInfo).getChangeLsn());
    }

    public long getEventSerialNo() {
        return this.eventSerialNo;
    }

    public void setChangePosition(TxLogPosition position, int eventCount) {
        this.eventSerialNo = this.getChangePosition().equals(position) ? (this.eventSerialNo += (long)eventCount) : (long)eventCount;
        ((SourceInfo)this.sourceInfo).setCommitLsn(position.getCommitLsn());
        ((SourceInfo)this.sourceInfo).setChangeLsn(position.getInTxLsn());
    }

    public boolean isSnapshotRunning() {
        return ((SourceInfo)this.sourceInfo).isSnapshot() && !this.snapshotCompleted;
    }

    public boolean isSnapshotCompleted() {
        return this.snapshotCompleted;
    }

    public void preSnapshotStart() {
        ((SourceInfo)this.sourceInfo).setSnapshot(SnapshotRecord.TRUE);
        this.snapshotCompleted = false;
    }

    public void preSnapshotCompletion() {
        this.snapshotCompleted = true;
    }

    public String toString() {
        return "Db2OffsetContext [sourceInfoSchema=" + String.valueOf(this.sourceInfoSchema) + ", sourceInfo=" + String.valueOf(this.sourceInfo) + ", snapshotCompleted=" + this.snapshotCompleted + ", eventSerialNo=" + this.eventSerialNo + "]";
    }

    public void event(DataCollectionId tableId, Instant timestamp) {
        ((SourceInfo)this.sourceInfo).setSourceTime(timestamp);
        ((SourceInfo)this.sourceInfo).setTableId((TableId)tableId);
    }

    public TransactionContext getTransactionContext() {
        return this.transactionContext;
    }

    public IncrementalSnapshotContext<?> getIncrementalSnapshotContext() {
        return this.incrementalSnapshotContext;
    }

    public static class Loader
    implements OffsetContext.Loader<Db2OffsetContext> {
        private final Db2ConnectorConfig connectorConfig;

        public Loader(Db2ConnectorConfig connectorConfig) {
            this.connectorConfig = connectorConfig;
        }

        public Db2OffsetContext load(Map<String, ?> offset) {
            Lsn changeLsn = Lsn.valueOf((String)offset.get("change_lsn"));
            Lsn commitLsn = Lsn.valueOf((String)offset.get("commit_lsn"));
            boolean snapshot = Boolean.TRUE.equals(offset.get("snapshot"));
            boolean snapshotCompleted = Boolean.TRUE.equals(offset.get(Db2OffsetContext.SNAPSHOT_COMPLETED_KEY));
            Long eventSerialNo = (Long)offset.get(Db2OffsetContext.EVENT_SERIAL_NO_KEY);
            if (eventSerialNo == null) {
                eventSerialNo = 0L;
            }
            return new Db2OffsetContext(this.connectorConfig, TxLogPosition.valueOf(commitLsn, changeLsn), snapshot, snapshotCompleted, eventSerialNo, TransactionContext.load(offset), (IncrementalSnapshotContext<TableId>)SignalBasedIncrementalSnapshotContext.load(offset, (boolean)false));
        }
    }
}

