/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.db2;

import io.debezium.bean.StandardBeanNames;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.connector.base.DefaultQueueProvider;
import io.debezium.connector.base.QueueProvider;
import io.debezium.connector.common.BaseSourceTask;
import io.debezium.connector.common.CdcSourceTaskContext;
import io.debezium.connector.common.DebeziumHeaderProducer;
import io.debezium.connector.db2.Db2ChangeEventSourceFactory;
import io.debezium.connector.db2.Db2Connection;
import io.debezium.connector.db2.Db2Connector;
import io.debezium.connector.db2.Db2ConnectorConfig;
import io.debezium.connector.db2.Db2DatabaseSchema;
import io.debezium.connector.db2.Db2EventMetadataProvider;
import io.debezium.connector.db2.Db2OffsetContext;
import io.debezium.connector.db2.Db2Partition;
import io.debezium.connector.db2.Db2TaskContext;
import io.debezium.connector.db2.Db2ValueConverters;
import io.debezium.connector.db2.Module;
import io.debezium.document.DocumentReader;
import io.debezium.jdbc.DefaultMainConnectionProvidingConnectionFactory;
import io.debezium.jdbc.MainConnectionProvidingConnectionFactory;
import io.debezium.pipeline.ChangeEventSourceCoordinator;
import io.debezium.pipeline.DataChangeEvent;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.metrics.DefaultChangeEventSourceMetricsFactory;
import io.debezium.pipeline.metrics.spi.ChangeEventSourceMetricsFactory;
import io.debezium.pipeline.notification.NotificationService;
import io.debezium.pipeline.signal.SignalProcessor;
import io.debezium.pipeline.source.spi.ChangeEventSourceFactory;
import io.debezium.pipeline.source.spi.EventMetadataProvider;
import io.debezium.pipeline.spi.Offsets;
import io.debezium.relational.CustomConverterRegistry;
import io.debezium.relational.TableId;
import io.debezium.schema.DataCollectionFilters;
import io.debezium.schema.DatabaseSchema;
import io.debezium.schema.SchemaFactory;
import io.debezium.schema.SchemaNameAdjuster;
import io.debezium.snapshot.SnapshotterService;
import io.debezium.spi.topic.TopicNamingStrategy;
import io.debezium.util.Clock;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Db2ConnectorTask
extends BaseSourceTask<Db2Partition, Db2OffsetContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Db2ConnectorTask.class);
    private static final String CONTEXT_NAME = "db2-server-connector-task";
    private volatile Db2TaskContext taskContext;
    private volatile ChangeEventQueue<DataChangeEvent> queue;
    private volatile Db2Connection dataConnection;
    private volatile Db2Connection metadataConnection;
    private volatile ErrorHandler errorHandler;
    private volatile Db2DatabaseSchema schema;
    private Db2ConnectorConfig connectorConfig;

    public String version() {
        return Module.version();
    }

    public CdcSourceTaskContext<? extends CommonConnectorConfig> preStart(Configuration config) {
        this.connectorConfig = new Db2ConnectorConfig(Db2ConnectorTask.applyFetchSizeToJdbcConfig(config));
        this.taskContext = new Db2TaskContext(config, this.connectorConfig);
        return this.taskContext;
    }

    public ChangeEventSourceCoordinator<Db2Partition, Db2OffsetContext> start(Configuration config) {
        TopicNamingStrategy topicNamingStrategy = this.connectorConfig.getTopicNamingStrategy(CommonConnectorConfig.TOPIC_NAMING_STRATEGY);
        SchemaNameAdjuster schemaNameAdjuster = this.connectorConfig.schemaNameAdjuster();
        LOGGER.info("Using Db2 {} platfrom, CDC control schema is {}, schema with change tables is {}", new Object[]{this.connectorConfig.getDb2Platform(), this.connectorConfig.getCdcControlSchema(), this.connectorConfig.getCdcChangeTablesSchema()});
        DefaultMainConnectionProvidingConnectionFactory connectionFactory = new DefaultMainConnectionProvidingConnectionFactory(() -> new Db2Connection(this.connectorConfig));
        this.dataConnection = (Db2Connection)connectionFactory.mainConnection();
        this.metadataConnection = (Db2Connection)connectionFactory.newConnection();
        try {
            this.dataConnection.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw new ConnectException((Throwable)e);
        }
        Db2ValueConverters valueConverters = new Db2ValueConverters(this.connectorConfig.getDecimalMode(), this.connectorConfig.getTemporalPrecisionMode());
        this.registerServiceProviders(this.connectorConfig.getServiceRegistry());
        this.schema = new Db2DatabaseSchema(this.connectorConfig, valueConverters, schemaNameAdjuster, (TopicNamingStrategy<TableId>)topicNamingStrategy, this.dataConnection, (CustomConverterRegistry)this.connectorConfig.getServiceRegistry().tryGetService(CustomConverterRegistry.class), this.taskContext);
        this.schema.initializeStorage();
        Offsets previousOffsets = this.getPreviousOffsets(new Db2Partition.Provider(this.connectorConfig), new Db2OffsetContext.Loader(this.connectorConfig));
        this.connectorConfig.getBeanRegistry().add(StandardBeanNames.CONFIGURATION, (Object)config);
        this.connectorConfig.getBeanRegistry().add("ConnectorConfig", (Object)this.connectorConfig);
        this.connectorConfig.getBeanRegistry().add("Schema", (Object)this.schema);
        this.connectorConfig.getBeanRegistry().add(StandardBeanNames.JDBC_CONNECTION, (Object)connectionFactory.newConnection());
        this.connectorConfig.getBeanRegistry().add(StandardBeanNames.VALUE_CONVERTER, (Object)valueConverters);
        this.connectorConfig.getBeanRegistry().add(StandardBeanNames.OFFSETS, (Object)previousOffsets);
        this.connectorConfig.getBeanRegistry().add(StandardBeanNames.CDC_SOURCE_TASK_CONTEXT, (Object)this.taskContext);
        SnapshotterService snapshotterService = (SnapshotterService)this.connectorConfig.getServiceRegistry().tryGetService(SnapshotterService.class);
        this.validateSchemaHistory((CommonConnectorConfig)this.connectorConfig, this.metadataConnection::validateLogPosition, previousOffsets, (DatabaseSchema)this.schema, snapshotterService.getSnapshotter());
        Clock clock = Clock.system();
        this.queue = new ChangeEventQueue.Builder().pollInterval(this.connectorConfig.getPollInterval()).maxBatchSize(this.connectorConfig.getMaxBatchSize()).maxQueueSize(this.connectorConfig.getMaxQueueSize()).loggingContextSupplier(() -> this.taskContext.configureLoggingContext(CONTEXT_NAME)).queueProvider((QueueProvider)new DefaultQueueProvider(this.connectorConfig.getMaxQueueSize())).build();
        this.errorHandler = new ErrorHandler(Db2Connector.class, (CommonConnectorConfig)this.connectorConfig, this.queue, this.errorHandler);
        Db2EventMetadataProvider metadataProvider = new Db2EventMetadataProvider();
        SignalProcessor signalProcessor = new SignalProcessor(Db2Connector.class, (CommonConnectorConfig)this.connectorConfig, Map.of(), this.getAvailableSignalChannels(), DocumentReader.defaultReader(), previousOffsets);
        EventDispatcher dispatcher = new EventDispatcher((CommonConnectorConfig)this.connectorConfig, topicNamingStrategy, (DatabaseSchema)this.schema, this.queue, (DataCollectionFilters.DataCollectionFilter)this.connectorConfig.getTableFilters().dataCollectionFilter(), DataChangeEvent::new, (EventMetadataProvider)metadataProvider, schemaNameAdjuster, signalProcessor, (DebeziumHeaderProducer)this.connectorConfig.getServiceRegistry().tryGetService(DebeziumHeaderProducer.class));
        NotificationService notificationService = new NotificationService(this.getNotificationChannels(), (CommonConnectorConfig)this.connectorConfig, SchemaFactory.get(), arg_0 -> ((EventDispatcher)dispatcher).enqueueNotification(arg_0));
        ChangeEventSourceCoordinator coordinator = new ChangeEventSourceCoordinator(previousOffsets, this.errorHandler, Db2Connector.class, (CommonConnectorConfig)this.connectorConfig, (ChangeEventSourceFactory)new Db2ChangeEventSourceFactory(this.connectorConfig, this.metadataConnection, (MainConnectionProvidingConnectionFactory<Db2Connection>)connectionFactory, this.errorHandler, (EventDispatcher<Db2Partition, TableId>)dispatcher, clock, this.schema, snapshotterService), (ChangeEventSourceMetricsFactory)new DefaultChangeEventSourceMetricsFactory(), dispatcher, (DatabaseSchema)this.schema, signalProcessor, notificationService, snapshotterService);
        coordinator.start((CdcSourceTaskContext)this.taskContext, this.queue, (EventMetadataProvider)metadataProvider);
        return coordinator;
    }

    protected String connectorName() {
        return Module.name();
    }

    public List<SourceRecord> doPoll() throws InterruptedException {
        List records = this.queue.poll();
        List<SourceRecord> sourceRecords = records.stream().map(DataChangeEvent::getRecord).collect(Collectors.toList());
        return sourceRecords;
    }

    protected Optional<ErrorHandler> getErrorHandler() {
        return Optional.ofNullable(this.errorHandler);
    }

    public void doStop() {
        block9: {
            try {
                if (this.dataConnection == null) break block9;
                if (this.dataConnection.isConnected()) {
                    try {
                        this.dataConnection.rollback();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                this.dataConnection.close();
            }
            catch (SQLException e) {
                LOGGER.error("Exception while closing JDBC connection", (Throwable)e);
            }
        }
        try {
            if (this.metadataConnection != null) {
                this.metadataConnection.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error("Exception while closing JDBC metadata connection", (Throwable)e);
        }
        if (this.schema != null) {
            this.schema.close();
        }
    }

    protected Iterable<Field> getAllConfigurationFields() {
        return Db2ConnectorConfig.ALL_FIELDS;
    }

    private static Configuration applyFetchSizeToJdbcConfig(Configuration config) {
        if (config.getInteger(Db2ConnectorConfig.QUERY_FETCH_SIZE) > 0) {
            String driverPrefix = "driver.";
            return ((Configuration.Builder)config.edit().withDefault("driver.responseBuffering", "adaptive").withDefault("driver.fetchSize", config.getInteger(Db2ConnectorConfig.QUERY_FETCH_SIZE))).build();
        }
        return config;
    }
}

