/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb.connection;

import com.mongodb.ConnectionString;
import com.mongodb.MongoCredential;
import com.mongodb.ReadPreference;
import com.mongodb.client.MongoClient;
import io.debezium.config.Configuration;
import io.debezium.connector.mongodb.Filters;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.connector.mongodb.connection.ConnectionStrings;
import io.debezium.connector.mongodb.connection.MongoDbClientFactory;
import io.debezium.connector.mongodb.connection.MongoDbConnection;
import io.debezium.connector.mongodb.connection.ReplicaSet;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionContext.class);
    private final Configuration config;
    private final MongoDbClientFactory clientFactory;

    public ConnectionContext(Configuration config) {
        this.config = config;
        String username = config.getString(MongoDbConnectorConfig.USER);
        String password = config.getString(MongoDbConnectorConfig.PASSWORD);
        String adminDbName = config.getString(MongoDbConnectorConfig.AUTH_SOURCE);
        boolean useSSL = config.getBoolean(MongoDbConnectorConfig.SSL_ENABLED);
        boolean sslAllowInvalidHostnames = config.getBoolean(MongoDbConnectorConfig.SSL_ALLOW_INVALID_HOSTNAMES);
        int connectTimeoutMs = config.getInteger(MongoDbConnectorConfig.CONNECT_TIMEOUT_MS);
        int heartbeatFrequencyMs = config.getInteger(MongoDbConnectorConfig.HEARTBEAT_FREQUENCY_MS);
        int socketTimeoutMs = config.getInteger(MongoDbConnectorConfig.SOCKET_TIMEOUT_MS);
        int serverSelectionTimeoutMs = config.getInteger(MongoDbConnectorConfig.SERVER_SELECTION_TIMEOUT_MS);
        this.clientFactory = MongoDbClientFactory.create(settings -> {
            settings.applyToSocketSettings(builder -> builder.connectTimeout(connectTimeoutMs, TimeUnit.MILLISECONDS).readTimeout(socketTimeoutMs, TimeUnit.MILLISECONDS)).applyToClusterSettings(builder -> builder.serverSelectionTimeout((long)serverSelectionTimeoutMs, TimeUnit.MILLISECONDS)).applyToServerSettings(builder -> builder.heartbeatFrequency((long)heartbeatFrequencyMs, TimeUnit.MILLISECONDS));
            if (username != null || password != null) {
                settings.credential(MongoCredential.createCredential((String)username, (String)adminDbName, (char[])password.toCharArray()));
            }
            if (useSSL) {
                settings.applyToSslSettings(builder -> builder.enabled(true).invalidHostNameAllowed(sslAllowInvalidHostnames));
            }
            settings.applyToSocketSettings(builder -> builder.connectTimeout(connectTimeoutMs, TimeUnit.MILLISECONDS).readTimeout(socketTimeoutMs, TimeUnit.MILLISECONDS)).applyToClusterSettings(builder -> builder.serverSelectionTimeout((long)serverSelectionTimeoutMs, TimeUnit.MILLISECONDS));
        });
    }

    public MongoDbConnectorConfig getConnectorConfig() {
        return new MongoDbConnectorConfig(this.config);
    }

    public String connectionSeed() {
        String seed = this.config.getString(MongoDbConnectorConfig.CONNECTION_STRING);
        if (seed == null) {
            String hosts = this.config.getString(MongoDbConnectorConfig.HOSTS);
            seed = ConnectionStrings.buildFromHosts(hosts);
        }
        return seed;
    }

    public ConnectionString connectionString() {
        return new ConnectionString(this.connectionSeed());
    }

    public String maskedConnectionSeed() {
        return ConnectionStrings.mask(this.connectionSeed());
    }

    public Duration pollInterval() {
        return Duration.ofMillis(this.config.getLong(MongoDbConnectorConfig.MONGODB_POLL_INTERVAL_MS));
    }

    public MongoClient connect() {
        return this.clientFactory.client(this.connectionString());
    }

    public MongoDbConnection connect(ReplicaSet replicaSet, ReadPreference preference, Filters filters, MongoDbConnection.ErrorHandler errorHandler) {
        return new MongoDbConnection(replicaSet, preference, this.clientFactory, filters, errorHandler);
    }
}

