/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb.connection;

import com.mongodb.ConnectionString;
import com.mongodb.MongoCredential;
import io.debezium.util.Strings;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ConnectionStrings {
    private static final Pattern HOST_PATTERN = Pattern.compile("(([^/]+)\\/)?(.+)");

    private ConnectionStrings() {
    }

    public static Optional<String> parseFromHosts(String hosts) {
        return ConnectionStrings.matcher(hosts).map(m -> ConnectionStrings.connectionString(m.group(2), m.group(3)));
    }

    public static String appendParameter(String connectionString, String name, String value) {
        String param = name + "=" + URLEncoder.encode(value, StandardCharsets.UTF_8);
        if (connectionString.endsWith("?")) {
            return connectionString + param;
        }
        if (connectionString.endsWith("/")) {
            return connectionString + "?" + param;
        }
        int pos = connectionString.lastIndexOf("?");
        if (pos == -1) {
            return connectionString + "/?" + param;
        }
        return connectionString + "&" + param;
    }

    public static String appendParameters(String connectionString, String parameters) {
        if (parameters == null || parameters.isBlank()) {
            return connectionString;
        }
        if (connectionString.endsWith("?")) {
            return connectionString + parameters;
        }
        if (connectionString.endsWith("/")) {
            return connectionString + "?" + parameters;
        }
        int pos = connectionString.lastIndexOf("?");
        if (pos == -1) {
            return connectionString + "/?" + parameters;
        }
        return connectionString + "&" + parameters;
    }

    public static String mask(String connectionString) {
        ConnectionString cs = new ConnectionString(connectionString);
        MongoCredential credentials = cs.getCredential();
        return credentials == null ? connectionString : Strings.mask((String)connectionString, (String)credentials.getUserName(), (String[])new String[]{credentials.getSource(), credentials.getPassword() != null ? String.valueOf(credentials.getPassword()) : null});
    }

    private static String connectionString(String rsName, String host) {
        if (rsName == null) {
            return String.format("mongodb://%s/", host);
        }
        return String.format("mongodb://%s/?replicaSet=%s", host, rsName);
    }

    private static Optional<Matcher> matcher(String hosts) {
        if (hosts == null || hosts.isBlank()) {
            return Optional.empty();
        }
        Matcher matcher = HOST_PATTERN.matcher(hosts);
        if (!matcher.matches()) {
            return Optional.empty();
        }
        return Optional.of(matcher);
    }
}

