/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import com.mongodb.client.MongoChangeStreamCursor;
import com.mongodb.client.model.changestream.ChangeStreamDocument;
import io.debezium.DebeziumException;
import io.debezium.connector.SnapshotRecord;
import io.debezium.connector.common.BaseSourceInfo;
import io.debezium.connector.common.OffsetUtils;
import io.debezium.connector.mongodb.CollectionId;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.connector.mongodb.ResumeTokens;
import io.debezium.connector.mongodb.SourceInfo;
import io.debezium.connector.mongodb.events.BufferingChangeStreamCursor;
import io.debezium.connector.mongodb.snapshot.MongoDbIncrementalSnapshotContext;
import io.debezium.pipeline.CommonOffsetContext;
import io.debezium.pipeline.source.snapshot.incremental.IncrementalSnapshotContext;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.txmetadata.TransactionContext;
import io.debezium.spi.schema.DataCollectionId;
import io.debezium.util.Collect;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.connect.data.Schema;
import org.bson.BsonDocument;
import org.bson.BsonTimestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDbOffsetContext
extends CommonOffsetContext<SourceInfo> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoDbOffsetContext.class);
    private final TransactionContext transactionContext;
    private final IncrementalSnapshotContext<CollectionId> incrementalSnapshotContext;

    public MongoDbOffsetContext(SourceInfo sourceInfo, TransactionContext transactionContext, IncrementalSnapshotContext<CollectionId> incrementalSnapshotContext) {
        super((BaseSourceInfo)sourceInfo);
        this.transactionContext = transactionContext;
        this.incrementalSnapshotContext = incrementalSnapshotContext;
    }

    void startInitialSnapshot() {
        ((SourceInfo)this.sourceInfo).startInitialSnapshot();
    }

    void stopInitialSnapshot() {
        ((SourceInfo)this.sourceInfo).stopInitialSnapshot();
    }

    public Map<String, ?> getOffset() {
        SourceInfo.Position position = ((SourceInfo)this.sourceInfo).position();
        Map offset = Collect.hashMapOf((Object)"sec", (Object)position.getTime(), (Object)"ord", (Object)position.getInc());
        if (this.isSnapshotRunning()) {
            offset.put("initsync", true);
        }
        this.addSessionTxnIdToOffset(position, offset);
        this.addResumeTokenToOffset(position, offset);
        return this.isSnapshotRunning() ? offset : this.incrementalSnapshotContext.store(this.transactionContext.store(offset));
    }

    private Map<String, Object> addSessionTxnIdToOffset(SourceInfo.Position position, Map<String, Object> offset) {
        if (position.getChangeStreamSessionTxnId() != null) {
            offset.put("lsid", position.getChangeStreamSessionTxnId().lsid);
            offset.put("txnNumber", position.getChangeStreamSessionTxnId().txnNumber);
        }
        return offset;
    }

    private Map<String, Object> addResumeTokenToOffset(SourceInfo.Position position, Map<String, Object> offset) {
        position.getResumeToken().ifPresent(resumeToken -> offset.put("resume_token", resumeToken));
        return offset;
    }

    public Schema getSourceInfoSchema() {
        return ((SourceInfo)this.sourceInfo).schema();
    }

    public boolean isSnapshotRunning() {
        return ((SourceInfo)this.sourceInfo).isSnapshot() && ((SourceInfo)this.sourceInfo).isSnapshotRunning();
    }

    public void preSnapshotStart() {
        ((SourceInfo)this.sourceInfo).setSnapshot(SnapshotRecord.TRUE);
    }

    public void preSnapshotCompletion() {
    }

    public TransactionContext getTransactionContext() {
        return this.transactionContext;
    }

    public IncrementalSnapshotContext<?> getIncrementalSnapshotContext() {
        return this.incrementalSnapshotContext;
    }

    public SourceInfo sourceInfo() {
        return (SourceInfo)this.sourceInfo;
    }

    public void event(DataCollectionId collectionId, Instant timestamp) {
        throw new UnsupportedOperationException();
    }

    public void readEvent(CollectionId collectionId, Instant timestamp) {
        ((SourceInfo)this.sourceInfo).collectionEvent(collectionId, 0L);
    }

    public void initEvent(MongoChangeStreamCursor<ChangeStreamDocument<BsonDocument>> cursor) {
        ((SourceInfo)this.sourceInfo).initEvent(cursor);
    }

    public void initFromOpTimeIfNeeded(BsonTimestamp timestamp) {
        if (this.lastResumeToken() != null) {
            return;
        }
        LOGGER.info("Initializing offset from operation time");
        ((SourceInfo)this.sourceInfo).noEvent(timestamp);
    }

    public void noEvent(BufferingChangeStreamCursor.ResumableChangeStreamEvent<BsonDocument> event) {
        ((SourceInfo)this.sourceInfo).noEvent(event);
    }

    public void changeStreamEvent(ChangeStreamDocument<BsonDocument> changeStreamEvent) {
        ((SourceInfo)this.sourceInfo).changeStreamEvent(changeStreamEvent);
    }

    public String lastResumeToken() {
        return ((SourceInfo)this.sourceInfo).lastResumeToken();
    }

    public BsonDocument lastResumeTokenDoc() {
        String data = ((SourceInfo)this.sourceInfo).lastResumeToken();
        return data == null ? null : ResumeTokens.fromData(data);
    }

    public BsonTimestamp lastTimestamp() {
        return ((SourceInfo)this.sourceInfo).lastTimestamp();
    }

    public BsonTimestamp lastTimestampOrTokenTime() {
        return Optional.of(this.lastResumeTokenDoc()).map(ResumeTokens::getTimestamp).orElseGet(this::lastTimestamp);
    }

    public boolean hasOffset() {
        return ((SourceInfo)this.sourceInfo).hasPosition();
    }

    private static int intOffsetValue(Map<String, ?> values, String key) {
        Object obj = values.get(key);
        if (obj == null) {
            return 0;
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        try {
            return Integer.parseInt(obj.toString());
        }
        catch (NumberFormatException e) {
            throw new DebeziumException("Source offset '" + key + "' parameter value " + obj + " could not be converted to an integer");
        }
    }

    public static MongoDbOffsetContext empty(MongoDbConnectorConfig connectorConfig) {
        return new MongoDbOffsetContext(new SourceInfo(connectorConfig), new TransactionContext(), new MongoDbIncrementalSnapshotContext<CollectionId>(false));
    }

    public String toString() {
        return "MongoDbOffsetContext [sourceInfo=" + this.sourceInfo + "]";
    }

    public static class Loader
    implements OffsetContext.Loader<MongoDbOffsetContext> {
        private final MongoDbConnectorConfig connectorConfig;

        public Loader(MongoDbConnectorConfig connectorConfig) {
            this.connectorConfig = connectorConfig;
        }

        public MongoDbOffsetContext load(Map<String, ?> offset) {
            SourceInfo sourceInfo = new SourceInfo(this.connectorConfig);
            if (!OffsetUtils.booleanOffsetValue(offset, (String)"initsync")) {
                SourceInfo.Position position = this.positionFromOffset(offset);
                sourceInfo.setPosition(position);
            }
            return new MongoDbOffsetContext(sourceInfo, new TransactionContext(), MongoDbIncrementalSnapshotContext.load(offset, false));
        }

        private SourceInfo.Position positionFromOffset(Map<String, ?> offset) {
            int time = MongoDbOffsetContext.intOffsetValue(offset, "sec");
            int order = MongoDbOffsetContext.intOffsetValue(offset, "ord");
            long changeStreamTxnNumber = OffsetUtils.longOffsetValue(offset, (String)"txnNumber");
            String changeStreamLsid = OffsetUtils.stringOffsetValue(offset, (String)"lsid");
            SourceInfo.SessionTransactionId changeStreamTxnId = null;
            if (changeStreamLsid != null) {
                changeStreamTxnId = new SourceInfo.SessionTransactionId(changeStreamLsid, changeStreamTxnNumber);
            }
            String resumeToken = OffsetUtils.stringOffsetValue(offset, (String)"resume_token");
            return new SourceInfo.Position(new BsonTimestamp(time, order), changeStreamTxnId, resumeToken);
        }
    }
}

