/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import com.mongodb.MongoException;
import com.mongodb.client.MongoClient;
import com.mongodb.connection.ClusterType;
import io.debezium.DebeziumException;
import io.debezium.config.Configuration;
import io.debezium.connector.common.BaseSourceConnector;
import io.debezium.connector.mongodb.CollectionId;
import io.debezium.connector.mongodb.Module;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.connector.mongodb.MongoDbConnectorTask;
import io.debezium.connector.mongodb.connection.MongoDbConnection;
import io.debezium.connector.mongodb.connection.MongoDbConnectionContext;
import io.debezium.connector.mongodb.connection.MongoDbConnections;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.Config;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigValue;
import org.apache.kafka.connect.connector.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDbConnector
extends BaseSourceConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoDbConnector.class);
    public static final String DEPRECATED_SHARD_CS_PARAMS_FILED = "mongodb.connection.string.shard.params";
    public static final String DEPRECATED_CONNECTION_MODE_FILED = "mongodb.connection.mode";
    private Configuration config;

    public String version() {
        return Module.version();
    }

    public Class<? extends Task> taskClass() {
        return MongoDbConnectorTask.class;
    }

    public void start(Map<String, String> props) {
        Configuration config = Configuration.from(props);
        if (!config.validateAndRecord((Iterable)MongoDbConnectorConfig.ALL_FIELDS, arg_0 -> ((Logger)LOGGER).error(arg_0))) {
            throw new DebeziumException("Error configuring an instance of " + ((Object)((Object)this)).getClass().getSimpleName() + "; check the logs for details");
        }
        this.config = config;
        LOGGER.info("Successfully started MongoDB connector");
    }

    public List<Map<String, String>> taskConfigs(int maxTasks) {
        if (this.config == null) {
            LOGGER.error("Configuring a maximum of {} tasks with no connector configuration available", (Object)maxTasks);
            return Collections.emptyList();
        }
        LOGGER.debug("Configuring MongoDB connector task");
        return List.of(this.config.asMap());
    }

    public void stop() {
        LOGGER.info("Stopping MongoDB connector");
        this.config = null;
        Thread.interrupted();
        LOGGER.info("Stopped MongoDB connector");
    }

    public ConfigDef config() {
        return MongoDbConnectorConfig.configDef();
    }

    public Config validate(Map<String, String> connectorConfigs) {
        Configuration config = Configuration.from(connectorConfigs);
        Map<String, ConfigValue> validation = this.validateAllFields(config);
        ConfigValue csValidation = validation.get(MongoDbConnectorConfig.CONNECTION_STRING.name());
        if (csValidation.errorMessages().isEmpty()) {
            this.validateConnection(config, csValidation);
        }
        return new Config(new ArrayList<ConfigValue>(validation.values()));
    }

    public void validateConnection(Configuration config, ConfigValue connectionStringValidation) {
        String mode;
        if (config.hasKey(DEPRECATED_SHARD_CS_PARAMS_FILED)) {
            LOGGER.warn("Field '{}' is deprecated. Use only '{}' to set connection parameters", (Object)DEPRECATED_SHARD_CS_PARAMS_FILED, (Object)MongoDbConnectorConfig.CONNECTION_STRING.name());
            connectionStringValidation.addErrorMessage("Deprecated field 'mongodb.connection.string.shard.params' is used");
        }
        if ((mode = config.getString(DEPRECATED_CONNECTION_MODE_FILED)) != null && mode.equals("replica_set")) {
            LOGGER.warn("Field '{}' is deprecated. Sharded mode is now used implicitly, please remove it. ", (Object)DEPRECATED_CONNECTION_MODE_FILED);
            connectionStringValidation.addErrorMessage("Deprecated field 'mongodb.connection.mode' is used set to removed 'replica_set' value");
        }
        MongoDbConnectionContext connectionContext = new MongoDbConnectionContext(config);
        try {
            try (MongoClient client = connectionContext.getMongoClient();){
                client.listDatabaseNames().first();
            }
            if (!connectionContext.hasReplicaSetNameIfRequired()) {
                ClusterType type = connectionContext.getClusterType();
                LOGGER.warn("Replica set not specified in connection string for {} cluster.", (Object)type);
                connectionStringValidation.addErrorMessage("Replica set not specified in connection string for " + String.valueOf(type) + " cluster.");
            }
        }
        catch (MongoException e) {
            connectionStringValidation.addErrorMessage("Unable to connect: " + e.getMessage());
        }
    }

    protected Map<String, ConfigValue> validateAllFields(Configuration config) {
        return config.validate(MongoDbConnectorConfig.ALL_FIELDS);
    }

    public List<CollectionId> getMatchingCollections(Configuration config) {
        MongoDbConnection connection = MongoDbConnections.create(config);
        try {
            List<CollectionId> list = connection.collections();
            if (connection != null) {
                connection.close();
            }
            return list;
        }
        catch (Throwable throwable) {
            try {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (InterruptedException e) {
                throw new DebeziumException((Throwable)e);
            }
        }
    }
}

