/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb.rest;

import io.debezium.config.Configuration;
import io.debezium.connector.mongodb.Module;
import io.debezium.connector.mongodb.MongoDbConnector;
import io.debezium.metadata.CollectionId;
import io.debezium.rest.ConnectionValidationResource;
import io.debezium.rest.FilterValidationResource;
import io.debezium.rest.MetricsResource;
import io.debezium.rest.SchemaResource;
import io.debezium.rest.model.MetricsDescriptor;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.management.MalformedObjectNameException;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.kafka.connect.health.ConnectClusterState;

@Path(value="/debezium/mongodb")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class DebeziumMongoDbConnectorResource
implements SchemaResource,
ConnectionValidationResource,
FilterValidationResource,
MetricsResource {
    public static final String BASE_PATH = "/debezium/mongodb";
    public static final String VERSION_ENDPOINT = "/version";
    private final ConnectClusterState connectClusterState;

    public DebeziumMongoDbConnectorResource(ConnectClusterState connectClusterState) {
        this.connectClusterState = connectClusterState;
    }

    @GET
    @Path(value="/version")
    public String getConnectorVersion() {
        return Module.version();
    }

    public MongoDbConnector getConnector() {
        return new MongoDbConnector();
    }

    public MetricsDescriptor getMetrics(String connectorName) throws MalformedObjectNameException {
        Map connectorConfig = this.connectClusterState.connectorConfig(connectorName);
        return this.queryMetrics(connectorConfig, connectorName, Module.contextName().toLowerCase(), "streaming");
    }

    public String getSchemaFilePath() {
        return "/META-INF/resources/mongodb.json";
    }

    public List<CollectionId> getMatchingCollections(Configuration configuration) {
        return this.getConnector().getMatchingCollections(configuration).stream().map(collectionId -> new CollectionId(collectionId.dbName(), collectionId.name())).collect(Collectors.toList());
    }
}

