/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.pipeline.spi.Partition;
import io.debezium.util.Collect;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class MongoDbPartition
implements Partition {
    private static final String SERVER_ID_KEY = "server_id";
    private static final String REPLICA_SET_NAME = "rs";
    private final String serverId;
    private final String replicaSetName;

    public MongoDbPartition(String serverId) {
        this.serverId = serverId;
        this.replicaSetName = null;
    }

    MongoDbPartition(String serverId, String replicaSetName) {
        this.serverId = serverId;
        this.replicaSetName = replicaSetName;
    }

    public Map<String, String> getSourcePartition() {
        return this.replicaSetName != null ? Collect.hashMapOf((Object)SERVER_ID_KEY, (Object)this.serverId, (Object)REPLICA_SET_NAME, (Object)this.replicaSetName) : Collect.hashMapOf((Object)SERVER_ID_KEY, (Object)this.serverId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MongoDbPartition other = (MongoDbPartition)obj;
        return Objects.equals(this.serverId, other.serverId) && Objects.equals(this.replicaSetName, other.replicaSetName);
    }

    public int hashCode() {
        return Objects.hash(this.serverId, this.replicaSetName);
    }

    public String toString() {
        return "MongoDbPartition [sourcePartition=" + String.valueOf(this.getSourcePartition()) + "]";
    }

    public static class Provider
    implements Partition.Provider<MongoDbPartition> {
        private final String logicalName;
        private final Set<String> replicaSetNames;

        public Provider(MongoDbConnectorConfig connectorConfig) {
            this(connectorConfig, Set.of());
        }

        Provider(MongoDbConnectorConfig connectorConfig, Set<String> replicaSetNames) {
            this.logicalName = connectorConfig.getLogicalName();
            this.replicaSetNames = replicaSetNames;
        }

        public Set<MongoDbPartition> getPartitions() {
            if (this.replicaSetNames.isEmpty()) {
                return Set.of(new MongoDbPartition(this.logicalName));
            }
            return this.replicaSetNames.stream().map(name -> new MongoDbPartition(this.logicalName, (String)name)).collect(Collectors.toSet());
        }
    }
}

