/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb.sink.converters;

import io.debezium.connector.mongodb.sink.converters.SinkValueConverter;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.errors.DataException;
import org.bson.BsonDocument;
import org.bson.RawBsonDocument;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.Codec;

class ByteArrayValueConverter
implements SinkValueConverter {
    private static final BsonDocumentCodec BSON_DOCUMENT_CODEC = new BsonDocumentCodec();

    ByteArrayValueConverter() {
    }

    @Override
    public BsonDocument convert(Schema schema, Object value) {
        if (value == null) {
            throw new DataException("BSON conversion failed due to record key and/or value was null");
        }
        return (BsonDocument)new RawBsonDocument((byte[])value).decode((Codec)BSON_DOCUMENT_CODEC);
    }
}

