/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.annotation.Immutable;
import io.debezium.config.Configuration;
import io.debezium.connector.mongodb.sink.Module;
import io.debezium.connector.mongodb.sink.MongoDbSinkConnectorConfig;
import io.debezium.connector.mongodb.sink.MongoDbSinkConnectorTask;
import io.debezium.connector.mongodb.sink.SinkConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.Config;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.Task;
import org.apache.kafka.connect.sink.SinkConnector;

public class MongoDbSinkConnector
extends SinkConnector {
    @Immutable
    private Map<String, String> properties;

    public String version() {
        return Module.version();
    }

    public void start(Map<String, String> props) {
        this.properties = Map.copyOf(props);
    }

    public Class<? extends Task> taskClass() {
        return MongoDbSinkConnectorTask.class;
    }

    public List<Map<String, String>> taskConfigs(int maxTasks) {
        ArrayList<Map<String, String>> configs = new ArrayList<Map<String, String>>(maxTasks);
        for (int i = 0; i < maxTasks; ++i) {
            configs.add(this.properties);
        }
        return configs;
    }

    public void stop() {
    }

    public ConfigDef config() {
        return MongoDbSinkConnectorConfig.configDef();
    }

    public Config validate(Map<String, String> connectorConfigs) {
        Config config = super.validate(connectorConfigs);
        try {
            MongoDbSinkConnectorConfig sinkConfig = new MongoDbSinkConnectorConfig(Configuration.from(connectorConfigs));
            sinkConfig.validate();
        }
        catch (Exception e) {
            return config;
        }
        SinkConnection.canConnect(config, MongoDbSinkConnectorConfig.CONNECTION_STRING);
        return config;
    }
}

