/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb.sink.eventhandler.relational;

import com.mongodb.client.model.WriteModel;
import io.debezium.connector.mongodb.sink.MongoDbSinkConnectorConfig;
import io.debezium.connector.mongodb.sink.converters.SinkDocument;
import io.debezium.connector.mongodb.sink.eventhandler.EventHandler;
import io.debezium.connector.mongodb.sink.eventhandler.EventOperation;
import io.debezium.connector.mongodb.sink.eventhandler.relational.RelationalDeleteEvent;
import io.debezium.connector.mongodb.sink.eventhandler.relational.RelationalInsertEvent;
import io.debezium.connector.mongodb.sink.eventhandler.relational.RelationalUpdateEvent;
import io.debezium.data.Envelope;
import io.debezium.sink.naming.ColumnNamingStrategy;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.connect.errors.DataException;
import org.bson.BsonDocument;
import org.bson.BsonInvalidOperationException;
import org.bson.BsonObjectId;
import org.bson.BsonValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelationalEventHandler
extends EventHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(RelationalEventHandler.class);
    private static final String ID_FIELD = "_id";
    private static final String JSON_DOC_BEFORE_FIELD = "before";
    private static final String JSON_DOC_AFTER_FIELD = "after";
    private static final Map<Envelope.Operation, EventOperation> DEFAULT_OPERATIONS = new HashMap<Envelope.Operation, EventOperation>(){
        {
            this.put(Envelope.Operation.CREATE, new RelationalInsertEvent());
            this.put(Envelope.Operation.READ, new RelationalInsertEvent());
            this.put(Envelope.Operation.UPDATE, new RelationalUpdateEvent());
            this.put(Envelope.Operation.DELETE, new RelationalDeleteEvent());
        }
    };

    public RelationalEventHandler(MongoDbSinkConnectorConfig config) {
        this(config, DEFAULT_OPERATIONS);
    }

    public RelationalEventHandler(MongoDbSinkConnectorConfig config, Map<Envelope.Operation, EventOperation> operations) {
        super(config);
        this.registerOperations(operations);
    }

    @Override
    public Optional<WriteModel<BsonDocument>> handle(SinkDocument doc) {
        BsonDocument keyDoc = doc.getKeyDoc().orElseGet(BsonDocument::new);
        BsonDocument valueDoc = doc.getValueDoc().orElseGet(BsonDocument::new);
        if (valueDoc.isEmpty()) {
            LOGGER.debug("Skipping debezium tombstone event for kafka topic compaction");
            return Optional.empty();
        }
        return Optional.ofNullable(this.getEventOperation(valueDoc).perform(new SinkDocument(keyDoc, valueDoc), this.getConfig().getColumnNamingStrategy()));
    }

    static BsonDocument generateFilterDoc(BsonDocument keyDoc, BsonDocument valueDoc, Envelope.Operation opType, ColumnNamingStrategy columnNamingStrategy) {
        if (keyDoc.keySet().isEmpty()) {
            if (opType.equals((Object)Envelope.Operation.CREATE) || opType.equals((Object)Envelope.Operation.READ)) {
                return new BsonDocument(ID_FIELD, (BsonValue)new BsonObjectId());
            }
            try {
                BsonDocument filter = valueDoc.getDocument((Object)JSON_DOC_BEFORE_FIELD);
                if (filter.isEmpty()) {
                    throw new BsonInvalidOperationException("value doc before field is empty");
                }
                return filter;
            }
            catch (BsonInvalidOperationException exc) {
                throw new DataException("Value doc 'before' field is empty or has invalid type for update/delete operation.  -> defensive actions taken!", (Throwable)exc);
            }
        }
        BsonDocument pk = new BsonDocument();
        for (String f : keyDoc.keySet()) {
            pk.put(columnNamingStrategy.resolveColumnName(f), keyDoc.get((Object)f));
        }
        return new BsonDocument(ID_FIELD, (BsonValue)pk);
    }

    public static BsonDocument generateUpsertOrReplaceDoc(BsonDocument keyDoc, BsonDocument valueDoc, BsonDocument filterDoc, ColumnNamingStrategy columnNamingStrategy) {
        if (!valueDoc.containsKey((Object)JSON_DOC_AFTER_FIELD) || valueDoc.get((Object)JSON_DOC_AFTER_FIELD).isNull() || !valueDoc.get((Object)JSON_DOC_AFTER_FIELD).isDocument() || valueDoc.getDocument((Object)JSON_DOC_AFTER_FIELD).isEmpty()) {
            throw new DataException("Value document must contain non-empty 'after' field of type document for insert/update operation");
        }
        BsonDocument upsertDoc = new BsonDocument();
        if (filterDoc.containsKey((Object)ID_FIELD)) {
            upsertDoc.put(ID_FIELD, filterDoc.get((Object)ID_FIELD));
        }
        BsonDocument afterDoc = valueDoc.getDocument((Object)JSON_DOC_AFTER_FIELD);
        for (String f : afterDoc.keySet()) {
            if (keyDoc.containsKey((Object)f)) continue;
            upsertDoc.put(columnNamingStrategy.resolveColumnName(f), afterDoc.get((Object)f));
        }
        return upsertDoc;
    }
}

