/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb.sink;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.ReadPreference;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.event.ClusterClosedEvent;
import com.mongodb.event.ClusterDescriptionChangedEvent;
import com.mongodb.event.ClusterListener;
import com.mongodb.event.ClusterOpeningEvent;
import io.debezium.config.Field;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.kafka.common.config.Config;
import org.apache.kafka.common.config.ConfigValue;
import org.apache.kafka.connect.errors.ConnectException;

public final class SinkConnection {
    public static Optional<MongoClient> canConnect(Config config, Field connectionStringConfigName) {
        Optional<ConfigValue> optionalConnectionString = SinkConnection.getConfigByName(config, connectionStringConfigName.name());
        if (optionalConnectionString.isPresent() && optionalConnectionString.get().errorMessages().isEmpty()) {
            ConfigValue configValue = optionalConnectionString.get();
            final AtomicBoolean connected = new AtomicBoolean();
            final CountDownLatch latch = new CountDownLatch(1);
            final ConnectionString connectionString = new ConnectionString((String)configValue.value());
            MongoClientSettings mongoClientSettings = MongoClientSettings.builder().applyConnectionString(connectionString).applyToClusterSettings(b -> b.addClusterListener(new ClusterListener(){

                public void clusterOpening(ClusterOpeningEvent event) {
                }

                public void clusterClosed(ClusterClosedEvent event) {
                }

                public void clusterDescriptionChanged(ClusterDescriptionChangedEvent event) {
                    ReadPreference readPreference;
                    ReadPreference readPreference2 = readPreference = connectionString.getReadPreference() != null ? connectionString.getReadPreference() : ReadPreference.primaryPreferred();
                    if (!connected.get() && event.getNewDescription().hasReadableServer(readPreference)) {
                        connected.set(true);
                        latch.countDown();
                    }
                }
            })).build();
            long latchTimeout = mongoClientSettings.getSocketSettings().getConnectTimeout(TimeUnit.MILLISECONDS) + 500;
            MongoClient mongoClient = MongoClients.create((MongoClientSettings)mongoClientSettings);
            try {
                if (!latch.await(latchTimeout, TimeUnit.MILLISECONDS)) {
                    configValue.addErrorMessage("Unable to connect to the server.");
                    mongoClient.close();
                }
            }
            catch (InterruptedException e) {
                mongoClient.close();
                throw new ConnectException((Throwable)e);
            }
            if (configValue.errorMessages().isEmpty()) {
                return Optional.of(mongoClient);
            }
        }
        return Optional.empty();
    }

    public static Optional<ConfigValue> getConfigByName(Config config, String name) {
        for (ConfigValue configValue : config.configValues()) {
            if (!configValue.name().equals(name)) continue;
            return Optional.of(configValue);
        }
        return Optional.empty();
    }

    private SinkConnection() {
    }
}

