/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql.antlr.listener;

import io.debezium.antlr.AntlrDdlParser;
import io.debezium.connector.mysql.antlr.MySqlAntlrDdlParser;
import io.debezium.connector.mysql.antlr.listener.ViewSelectedColumnsParserListener;
import io.debezium.ddl.parser.mysql.generated.MySqlParser;
import io.debezium.ddl.parser.mysql.generated.MySqlParserBaseListener;
import io.debezium.relational.Column;
import io.debezium.relational.TableEditor;
import io.debezium.relational.TableId;
import io.debezium.text.ParsingException;
import java.util.List;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTreeListener;

public class AlterViewParserListener
extends MySqlParserBaseListener {
    private final MySqlAntlrDdlParser parser;
    private final List<ParseTreeListener> listeners;
    private TableEditor tableEditor;
    private ViewSelectedColumnsParserListener selectColumnsListener;

    public AlterViewParserListener(MySqlAntlrDdlParser parser, List<ParseTreeListener> listeners) {
        this.parser = parser;
        this.listeners = listeners;
    }

    public void enterAlterView(MySqlParser.AlterViewContext ctx) {
        if (!this.parser.skipViews()) {
            TableId tableId = this.parser.parseQualifiedTableId(ctx.fullId());
            this.tableEditor = this.parser.databaseTables().editTable(tableId);
            if (this.tableEditor == null) {
                throw new ParsingException(null, "Trying to alter view " + tableId.toString() + ", which does not exist. Query:" + AntlrDdlParser.getText((ParserRuleContext)ctx));
            }
            this.tableEditor.columnNames().forEach(arg_0 -> ((TableEditor)this.tableEditor).removeColumn(arg_0));
            if (ctx.uidList() != null) {
                ctx.uidList().uid().stream().map(this.parser::parseName).forEach(columnName -> this.tableEditor.addColumn(Column.editor().name(columnName).create()));
            }
            this.selectColumnsListener = new ViewSelectedColumnsParserListener(this.tableEditor, this.parser);
            this.listeners.add((ParseTreeListener)this.selectColumnsListener);
        }
        super.enterAlterView(ctx);
    }

    public void exitAlterView(MySqlParser.AlterViewContext ctx) {
        this.parser.runIfNotNull(() -> {
            this.tableEditor.addColumns(this.selectColumnsListener.getSelectedColumns());
            if (!this.tableEditor.hasDefaultCharsetName()) {
                this.tableEditor.setDefaultCharsetName(this.parser.currentDatabaseCharset());
            }
            this.parser.databaseTables().overwriteTable(this.tableEditor.create());
            this.listeners.remove((Object)this.selectColumnsListener);
        }, this.tableEditor);
        this.parser.signalAlterView(this.parser.parseQualifiedTableId(ctx.fullId()), null, (ParserRuleContext)ctx);
        super.exitAlterView(ctx);
    }
}

