/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql.strategy.mariadb;

import com.github.shyiko.mysql.binlog.BinaryLogClient;
import com.github.shyiko.mysql.binlog.event.EventType;
import com.github.shyiko.mysql.binlog.event.deserialization.EventDeserializer;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.strategy.AbstractBinaryLogClientConfigurator;
import io.debezium.connector.mysql.strategy.AbstractConnectorConnection;
import java.util.concurrent.ThreadFactory;

public class MariaDbBinaryLogClientConfigurator
extends AbstractBinaryLogClientConfigurator {
    public MariaDbBinaryLogClientConfigurator(MySqlConnectorConfig connectorConfig) {
        super(connectorConfig);
    }

    @Override
    public BinaryLogClient configure(BinaryLogClient client, ThreadFactory threadFactory, AbstractConnectorConnection connection) {
        BinaryLogClient result = super.configure(client, threadFactory, connection);
        if (this.getConnectorConfig().includeSqlQuery()) {
            result.setUseSendAnnotateRowsEvent(true);
        }
        return result;
    }

    @Override
    public EventType getIncludeSqlQueryEventType() {
        return EventType.ANNOTATE_ROWS;
    }

    @Override
    protected void configureReplicaCompatibility(BinaryLogClient client) {
        client.setMariaDbSlaveCapability(4);
    }

    @Override
    protected EventDeserializer createEventDeserializer() {
        EventDeserializer eventDeserializer = super.createEventDeserializer();
        eventDeserializer.setCompatibilityMode(EventDeserializer.CompatibilityMode.CHAR_AND_BINARY_AS_BYTE_ARRAY, new EventDeserializer.CompatibilityMode[0]);
        return eventDeserializer;
    }
}

