/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql.strategy.mariadb;

import io.debezium.connector.mysql.strategy.mariadb.MariaDbGtidSet;
import io.debezium.pipeline.source.snapshot.incremental.AbstractIncrementalSnapshotContext;
import io.debezium.pipeline.source.snapshot.incremental.IncrementalSnapshotContext;
import io.debezium.pipeline.spi.OffsetContext;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MariaDbReadOnlyIncrementalSnapshotContext<T>
extends AbstractIncrementalSnapshotContext<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MariaDbReadOnlyIncrementalSnapshotContext.class);
    private MariaDbGtidSet previousLowWatermark;
    private MariaDbGtidSet previousHighWatermark;
    private MariaDbGtidSet lowWatermark;
    private MariaDbGtidSet highWatermark;
    private Long signalOffset;
    public static final String SIGNAL_OFFSET = "incremental_snapshot_signal_offset";

    public MariaDbReadOnlyIncrementalSnapshotContext() {
        this(true);
    }

    public MariaDbReadOnlyIncrementalSnapshotContext(boolean useCatalogBeforeSchema) {
        super(useCatalogBeforeSchema);
    }

    protected static <U> IncrementalSnapshotContext<U> init(MariaDbReadOnlyIncrementalSnapshotContext<U> context, Map<String, ?> offsets) {
        AbstractIncrementalSnapshotContext.init(context, offsets);
        Long signalOffset = (Long)offsets.get(SIGNAL_OFFSET);
        context.setSignalOffset(signalOffset);
        return context;
    }

    public static <U> MariaDbReadOnlyIncrementalSnapshotContext<U> load(Map<String, ?> offsets) {
        return MariaDbReadOnlyIncrementalSnapshotContext.load(offsets, true);
    }

    public static <U> MariaDbReadOnlyIncrementalSnapshotContext<U> load(Map<String, ?> offsets, boolean useCatalogBeforeSchema) {
        MariaDbReadOnlyIncrementalSnapshotContext context = new MariaDbReadOnlyIncrementalSnapshotContext(useCatalogBeforeSchema);
        MariaDbReadOnlyIncrementalSnapshotContext.init(context, offsets);
        return context;
    }

    public void setLowWatermark(MariaDbGtidSet lowWatermark) {
        this.lowWatermark = lowWatermark;
    }

    public void setHighWatermark(MariaDbGtidSet highWatermark) {
        this.highWatermark = highWatermark.subtract(this.lowWatermark);
    }

    public boolean updateWindowState(OffsetContext offsetContext) {
        String currentGtid = this.getCurrentGtid(offsetContext);
        if (!this.windowOpened && this.lowWatermark != null) {
            boolean pastLowWatermark;
            boolean bl = pastLowWatermark = !this.lowWatermark.contains(currentGtid);
            if (pastLowWatermark) {
                LOGGER.debug("Current gtid {}, low watermark {}", (Object)currentGtid, (Object)this.lowWatermark);
                this.windowOpened = true;
            }
        }
        if (this.windowOpened && this.highWatermark != null) {
            boolean pastHighWatermark;
            boolean bl = pastHighWatermark = !this.highWatermark.contains(currentGtid);
            if (pastHighWatermark) {
                LOGGER.debug("Current gtid {}, high watermark {}", (Object)currentGtid, (Object)this.highWatermark);
                this.closeWindow();
                return true;
            }
        }
        return false;
    }

    public boolean reachedHighWatermark(String currentGtid) {
        long maxSequenceId;
        if (this.highWatermark == null) {
            return false;
        }
        if (currentGtid == null) {
            return true;
        }
        MariaDbGtidSet.MariaDbGtid currentMariaDbGtid = MariaDbGtidSet.parse(currentGtid);
        MariaDbGtidSet.MariaDbStreamSet streamSet = this.getStreamSetForGtid(currentMariaDbGtid);
        if (streamSet != null && (maxSequenceId = streamSet.stream().mapToLong(MariaDbGtidSet.MariaDbGtid::getSequence).max().getAsLong()) <= currentMariaDbGtid.getSequence()) {
            LOGGER.debug("Gtid {} reached high watermark {}", (Object)currentGtid, (Object)this.highWatermark);
            return true;
        }
        return false;
    }

    public String getCurrentGtid(OffsetContext offsetContext) {
        return offsetContext.getSourceInfo().getString("gtid");
    }

    public void closeWindow() {
        this.windowOpened = false;
        this.previousHighWatermark = this.highWatermark;
        this.highWatermark = null;
        this.previousLowWatermark = this.lowWatermark;
        this.lowWatermark = null;
    }

    private MariaDbGtidSet.MariaDbStreamSet getStreamSetForGtid(MariaDbGtidSet.MariaDbGtid currentGtid) {
        return this.highWatermark.isEmpty() ? this.lowWatermark.forGtidStream(currentGtid) : this.highWatermark.forGtidStream(currentGtid);
    }

    public boolean serverStreamSetChanged() {
        return !this.highWatermark.isEmpty();
    }

    public Long getSignalOffset() {
        return this.signalOffset;
    }

    public void setSignalOffset(Long signalOffset) {
        this.signalOffset = signalOffset;
    }

    public Map<String, Object> store(Map<String, Object> offset) {
        Map snapshotOffset = super.store(offset);
        snapshotOffset.put(SIGNAL_OFFSET, this.signalOffset);
        return snapshotOffset;
    }

    public boolean watermarksChanged() {
        return !this.previousLowWatermark.equals(this.lowWatermark) || !this.previousHighWatermark.equals(this.highWatermark);
    }
}

