/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql.strategy;

import com.github.shyiko.mysql.binlog.BinaryLogClient;
import com.github.shyiko.mysql.binlog.event.Event;
import com.github.shyiko.mysql.binlog.event.EventData;
import com.github.shyiko.mysql.binlog.event.EventHeader;
import com.github.shyiko.mysql.binlog.event.EventHeaderV4;
import com.github.shyiko.mysql.binlog.event.EventType;
import com.github.shyiko.mysql.binlog.event.TableMapEventData;
import com.github.shyiko.mysql.binlog.event.TransactionPayloadEventData;
import com.github.shyiko.mysql.binlog.event.deserialization.EventDataDeserializationException;
import com.github.shyiko.mysql.binlog.event.deserialization.EventDataDeserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.EventDeserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.GtidEventDataDeserializer;
import com.github.shyiko.mysql.binlog.io.ByteArrayInputStream;
import com.github.shyiko.mysql.binlog.network.DefaultSSLSocketFactory;
import com.github.shyiko.mysql.binlog.network.SSLMode;
import com.github.shyiko.mysql.binlog.network.SSLSocketFactory;
import io.debezium.DebeziumException;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.connector.mysql.EventDataDeserializationExceptionData;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.RowDeserializers;
import io.debezium.connector.mysql.StopEventDataDeserializer;
import io.debezium.connector.mysql.TransactionPayloadDeserializer;
import io.debezium.connector.mysql.strategy.AbstractConnectorConnection;
import io.debezium.connector.mysql.strategy.BinaryLogClientConfigurator;
import io.debezium.util.Strings;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.concurrent.ThreadFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBinaryLogClientConfigurator
implements BinaryLogClientConfigurator {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractBinaryLogClientConfigurator.class);
    private final MySqlConnectorConfig connectorConfig;
    private final float heartbeatIntervalFactor = 0.8f;
    private final CommonConnectorConfig.EventProcessingFailureHandlingMode eventDeserializationFailureHandlingMode;

    public AbstractBinaryLogClientConfigurator(MySqlConnectorConfig connectorConfig) {
        this.connectorConfig = connectorConfig;
        this.eventDeserializationFailureHandlingMode = connectorConfig.getEventProcessingFailureHandlingMode();
    }

    @Override
    public BinaryLogClient configure(BinaryLogClient client, ThreadFactory threadFactory, AbstractConnectorConnection connection) {
        SSLSocketFactory sslSocketFactory;
        client.setThreadFactory(threadFactory);
        client.setServerId(this.connectorConfig.serverId());
        client.setSSLMode(this.sslModeFor(this.connectorConfig.sslMode()));
        if (this.connectorConfig.sslModeEnabled() && (sslSocketFactory = this.getBinlogSslSocketFactory(this.connectorConfig, connection)) != null) {
            client.setSslSocketFactory(sslSocketFactory);
        }
        this.configureReplicaCompatibility(client);
        Configuration configuration = this.connectorConfig.getConfig();
        client.setKeepAlive(configuration.getBoolean(MySqlConnectorConfig.KEEP_ALIVE));
        long keepAliveInterval = configuration.getLong(MySqlConnectorConfig.KEEP_ALIVE_INTERVAL_MS);
        client.setKeepAliveInterval(keepAliveInterval);
        client.setHeartbeatInterval((long)((float)keepAliveInterval * 0.8f));
        client.setEventDeserializer(this.createEventDeserializer());
        return client;
    }

    protected EventDeserializer createEventDeserializer() {
        final HashMap<Long, TableMapEventData> tableMapEventByTableId = new HashMap<Long, TableMapEventData>();
        EventDeserializer eventDeserializer = new EventDeserializer(){

            public Event nextEvent(ByteArrayInputStream inputStream) throws IOException {
                try {
                    Event event = super.nextEvent(inputStream);
                    if (event.getHeader().getEventType() == EventType.TABLE_MAP) {
                        TableMapEventData tableMapEvent = (TableMapEventData)event.getData();
                        tableMapEventByTableId.put(tableMapEvent.getTableId(), tableMapEvent);
                    }
                    if (event.getHeader().getEventType() == EventType.TRANSACTION_PAYLOAD) {
                        TransactionPayloadEventData transactionPayloadEventData = (TransactionPayloadEventData)event.getData();
                        for (Event uncompressedEvent : transactionPayloadEventData.getUncompressedEvents()) {
                            if (uncompressedEvent.getHeader().getEventType() != EventType.TABLE_MAP || uncompressedEvent.getData() == null) continue;
                            TableMapEventData tableMapEvent = (TableMapEventData)uncompressedEvent.getData();
                            tableMapEventByTableId.put(tableMapEvent.getTableId(), tableMapEvent);
                        }
                    }
                    if (event.getHeader().getEventType() == EventType.ROTATE && event.getHeader().getTimestamp() != 0L) {
                        tableMapEventByTableId.clear();
                    }
                    return event;
                }
                catch (EventDataDeserializationException edde) {
                    if (edde.getCause() instanceof IOException) {
                        throw edde;
                    }
                    EventHeaderV4 header = new EventHeaderV4();
                    header.setEventType(EventType.INCIDENT);
                    header.setTimestamp(edde.getEventHeader().getTimestamp());
                    header.setServerId(edde.getEventHeader().getServerId());
                    if (edde.getEventHeader() instanceof EventHeaderV4) {
                        header.setEventLength(((EventHeaderV4)edde.getEventHeader()).getEventLength());
                        header.setNextPosition(((EventHeaderV4)edde.getEventHeader()).getNextPosition());
                        header.setFlags(((EventHeaderV4)edde.getEventHeader()).getFlags());
                    }
                    EventDataDeserializationExceptionData data = new EventDataDeserializationExceptionData(edde);
                    return new Event((EventHeader)header, (EventData)data);
                }
            }
        };
        eventDeserializer.setEventDataDeserializer(EventType.STOP, (EventDataDeserializer)new StopEventDataDeserializer());
        eventDeserializer.setEventDataDeserializer(EventType.GTID, (EventDataDeserializer)new GtidEventDataDeserializer());
        eventDeserializer.setEventDataDeserializer(EventType.WRITE_ROWS, (EventDataDeserializer)new RowDeserializers.WriteRowsDeserializer(tableMapEventByTableId, this.eventDeserializationFailureHandlingMode));
        eventDeserializer.setEventDataDeserializer(EventType.UPDATE_ROWS, (EventDataDeserializer)new RowDeserializers.UpdateRowsDeserializer(tableMapEventByTableId, this.eventDeserializationFailureHandlingMode));
        eventDeserializer.setEventDataDeserializer(EventType.DELETE_ROWS, (EventDataDeserializer)new RowDeserializers.DeleteRowsDeserializer(tableMapEventByTableId, this.eventDeserializationFailureHandlingMode));
        eventDeserializer.setEventDataDeserializer(EventType.EXT_WRITE_ROWS, (EventDataDeserializer)new RowDeserializers.WriteRowsDeserializer(tableMapEventByTableId, this.eventDeserializationFailureHandlingMode).setMayContainExtraInformation(true));
        eventDeserializer.setEventDataDeserializer(EventType.EXT_UPDATE_ROWS, (EventDataDeserializer)new RowDeserializers.UpdateRowsDeserializer(tableMapEventByTableId, this.eventDeserializationFailureHandlingMode).setMayContainExtraInformation(true));
        eventDeserializer.setEventDataDeserializer(EventType.EXT_DELETE_ROWS, (EventDataDeserializer)new RowDeserializers.DeleteRowsDeserializer(tableMapEventByTableId, this.eventDeserializationFailureHandlingMode).setMayContainExtraInformation(true));
        eventDeserializer.setEventDataDeserializer(EventType.TRANSACTION_PAYLOAD, (EventDataDeserializer)new TransactionPayloadDeserializer(tableMapEventByTableId, this.eventDeserializationFailureHandlingMode));
        return eventDeserializer;
    }

    @Override
    public EventType getIncludeSqlQueryEventType() {
        return EventType.ROWS_QUERY;
    }

    protected MySqlConnectorConfig getConnectorConfig() {
        return this.connectorConfig;
    }

    protected void configureReplicaCompatibility(BinaryLogClient client) {
    }

    private SSLMode sslModeFor(MySqlConnectorConfig.SecureConnectionMode mode) {
        switch (mode) {
            case DISABLED: {
                return SSLMode.DISABLED;
            }
            case PREFERRED: {
                return SSLMode.PREFERRED;
            }
            case REQUIRED: {
                return SSLMode.REQUIRED;
            }
            case VERIFY_CA: {
                return SSLMode.VERIFY_CA;
            }
            case VERIFY_IDENTITY: {
                return SSLMode.VERIFY_IDENTITY;
            }
        }
        return null;
    }

    private SSLSocketFactory getBinlogSslSocketFactory(MySqlConnectorConfig connectorConfig, AbstractConnectorConnection connection) {
        String acceptedTlsVersion = connection.getSessionVariableForSslVersion();
        if (!Strings.isNullOrEmpty((String)acceptedTlsVersion)) {
            TrustManager[] trustManagers;
            SSLMode sslMode = this.sslModeFor(connectorConfig.sslMode());
            LOGGER.info("Enable ssl " + sslMode + " mode for connector " + connectorConfig.getLogicalName());
            char[] keyPasswordArray = connection.connectionConfig().sslKeyStorePassword();
            String keyFilename = connection.connectionConfig().sslKeyStore();
            char[] trustPasswordArray = connection.connectionConfig().sslTrustStorePassword();
            String trustFilename = connection.connectionConfig().sslTrustStore();
            KeyManager[] keyManagers = null;
            if (keyFilename != null) {
                try {
                    KeyStore ks = connection.loadKeyStore(keyFilename, keyPasswordArray);
                    KeyManagerFactory kmf = KeyManagerFactory.getInstance("NewSunX509");
                    kmf.init(ks, keyPasswordArray);
                    keyManagers = kmf.getKeyManagers();
                }
                catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
                    throw new DebeziumException("Could not load keystore", (Throwable)e);
                }
            }
            try {
                KeyStore ks = null;
                if (trustFilename != null) {
                    ks = connection.loadKeyStore(trustFilename, trustPasswordArray);
                }
                if (ks == null && (sslMode == SSLMode.PREFERRED || sslMode == SSLMode.REQUIRED)) {
                    trustManagers = new TrustManager[]{new X509TrustManager(){

                        @Override
                        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                        }

                        @Override
                        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                        }

                        @Override
                        public X509Certificate[] getAcceptedIssuers() {
                            return new X509Certificate[0];
                        }
                    }};
                } else {
                    TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    tmf.init(ks);
                    trustManagers = tmf.getTrustManagers();
                }
            }
            catch (KeyStoreException | NoSuchAlgorithmException e) {
                throw new DebeziumException("Could not load truststore", (Throwable)e);
            }
            final KeyManager[] finalKMS = keyManagers;
            return new DefaultSSLSocketFactory(acceptedTlsVersion){

                protected void initSSLContext(SSLContext sc) throws GeneralSecurityException {
                    sc.init(finalKMS, trustManagers, null);
                }
            };
        }
        return null;
    }
}

