/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql.strategy;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.strategy.ConnectionConfiguration;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.util.Strings;
import java.time.Duration;

public abstract class AbstractConnectionConfiguration
implements ConnectionConfiguration {
    public static final String URL_PATTERN = "${protocol}://${hostname}:${port}/?useInformationSchema=true&nullCatalogMeansCurrent=false&useUnicode=true&characterEncoding=UTF-8&characterSetResults=UTF-8&zeroDateTimeBehavior=CONVERT_TO_NULL&connectTimeout=${connectTimeout}";
    private final JdbcConfiguration jdbcConfig;
    private final JdbcConnection.ConnectionFactory factory;
    private final Configuration config;

    public AbstractConnectionConfiguration(Configuration config) {
        this.config = config;
        boolean useSSL = this.sslModeEnabled();
        Configuration dbConfig = ((Configuration.Builder)((Configuration.Builder)config.edit().withDefault(MySqlConnectorConfig.PORT, MySqlConnectorConfig.PORT.defaultValue())).withDefault(MySqlConnectorConfig.JDBC_PROTOCOL, MySqlConnectorConfig.JDBC_PROTOCOL.defaultValue())).build().subset("database.", true).merge(new Configuration[]{config.subset("driver.", true)});
        Configuration.Builder jdbcConfigBuilder = dbConfig.edit().with("connectTimeout", Long.toString(this.getConnectionTimeout().toMillis())).with("sslMode", this.sslMode().getValue());
        if (useSSL) {
            if (!Strings.isNullOrBlank((String)this.sslTrustStore())) {
                jdbcConfigBuilder.with("trustCertificateKeyStoreUrl", "file:" + this.sslTrustStore());
            }
            if (this.sslTrustStorePassword() != null) {
                jdbcConfigBuilder.with("trustCertificateKeyStorePassword", String.valueOf(this.sslTrustStorePassword()));
            }
            if (!Strings.isNullOrBlank((String)this.sslKeyStore())) {
                jdbcConfigBuilder.with("clientCertificateKeyStoreUrl", "file:" + this.sslKeyStore());
            }
            if (this.sslKeyStorePassword() != null) {
                jdbcConfigBuilder.with("clientCertificateKeyStorePassword", String.valueOf(this.sslKeyStorePassword()));
            }
        }
        jdbcConfigBuilder.with(this.getConnectionTimeZonePropertyName(), this.resolveConnectionTimeZone(dbConfig));
        ((Configuration.Builder)jdbcConfigBuilder.with("allowLoadLocalInfile", "false").with("allowUrlInLocalInfile", "false").with("autoDeserialize", false)).without("queryInterceptors");
        this.jdbcConfig = JdbcConfiguration.adapt((Configuration)jdbcConfigBuilder.build());
        String driverClassName = this.config.getString(MySqlConnectorConfig.JDBC_DRIVER);
        Field protocol = MySqlConnectorConfig.JDBC_PROTOCOL;
        this.factory = JdbcConnection.patternBasedFactory((String)URL_PATTERN, (String)driverClassName, (ClassLoader)this.getClass().getClassLoader(), (Field[])new Field[]{protocol});
    }

    @Override
    public JdbcConfiguration config() {
        return this.jdbcConfig;
    }

    @Override
    public Configuration originalConfig() {
        return this.config;
    }

    @Override
    public JdbcConnection.ConnectionFactory factory() {
        return this.factory;
    }

    @Override
    public String username() {
        return this.config.getString(MySqlConnectorConfig.USER);
    }

    @Override
    public String password() {
        return this.config.getString(MySqlConnectorConfig.PASSWORD);
    }

    @Override
    public String hostname() {
        return this.config.getString(MySqlConnectorConfig.HOSTNAME);
    }

    @Override
    public int port() {
        return this.config.getInteger(MySqlConnectorConfig.PORT);
    }

    @Override
    public MySqlConnectorConfig.SecureConnectionMode sslMode() {
        String mode = this.config.getString(MySqlConnectorConfig.SSL_MODE);
        return MySqlConnectorConfig.SecureConnectionMode.parse(mode);
    }

    @Override
    public boolean sslModeEnabled() {
        return this.sslMode() != MySqlConnectorConfig.SecureConnectionMode.DISABLED;
    }

    @Override
    public String sslKeyStore() {
        return this.config.getString(MySqlConnectorConfig.SSL_KEYSTORE);
    }

    @Override
    public char[] sslKeyStorePassword() {
        String password = this.config.getString(MySqlConnectorConfig.SSL_KEYSTORE_PASSWORD);
        return Strings.isNullOrBlank((String)password) ? null : password.toCharArray();
    }

    @Override
    public String sslTrustStore() {
        return this.config.getString(MySqlConnectorConfig.SSL_TRUSTSTORE);
    }

    @Override
    public char[] sslTrustStorePassword() {
        String password = this.config.getString(MySqlConnectorConfig.SSL_TRUSTSTORE_PASSWORD);
        return Strings.isNullOrBlank((String)password) ? null : password.toCharArray();
    }

    public Duration getConnectionTimeout() {
        return Duration.ofMillis(this.config.getLong(MySqlConnectorConfig.CONNECTION_TIMEOUT_MS));
    }

    public CommonConnectorConfig.EventProcessingFailureHandlingMode eventProcessingFailureHandlingMode() {
        String mode = this.config.getString(CommonConnectorConfig.EVENT_PROCESSING_FAILURE_HANDLING_MODE);
        if (mode == null) {
            mode = this.config.getString(MySqlConnectorConfig.EVENT_DESERIALIZATION_FAILURE_HANDLING_MODE);
        }
        return CommonConnectorConfig.EventProcessingFailureHandlingMode.parse((String)mode);
    }

    public CommonConnectorConfig.EventProcessingFailureHandlingMode inconsistentSchemaHandlingMode() {
        String mode = this.config.getString(MySqlConnectorConfig.INCONSISTENT_SCHEMA_HANDLING_MODE);
        return CommonConnectorConfig.EventProcessingFailureHandlingMode.parse((String)mode);
    }

    protected abstract String getConnectionTimeZonePropertyName();

    protected abstract String resolveConnectionTimeZone(Configuration var1);
}

