/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql.strategy.mariadb;

import com.github.shyiko.mysql.binlog.event.AnnotateRowsEventData;
import com.github.shyiko.mysql.binlog.event.EventData;
import io.debezium.DebeziumException;
import io.debezium.config.Configuration;
import io.debezium.connector.mysql.MariaDbProtocolFieldReader;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlDatabaseSchema;
import io.debezium.connector.mysql.MySqlFieldReader;
import io.debezium.connector.mysql.MySqlOffsetContext;
import io.debezium.connector.mysql.MySqlPartition;
import io.debezium.connector.mysql.strategy.AbstractConnectorConnection;
import io.debezium.connector.mysql.strategy.AbstractHistoryRecordComparator;
import io.debezium.connector.mysql.strategy.BinaryLogClientConfigurator;
import io.debezium.connector.mysql.strategy.ConnectorAdapter;
import io.debezium.connector.mysql.strategy.mariadb.MariaDbBinaryLogClientConfigurator;
import io.debezium.connector.mysql.strategy.mariadb.MariaDbConnection;
import io.debezium.connector.mysql.strategy.mariadb.MariaDbConnectionConfiguration;
import io.debezium.connector.mysql.strategy.mariadb.MariaDbHistoryRecordComparator;
import io.debezium.connector.mysql.strategy.mariadb.MariaDbReadOnlyIncrementalSnapshotChangeEventSource;
import io.debezium.connector.mysql.strategy.mariadb.MariaDbReadOnlyIncrementalSnapshotContext;
import io.debezium.connector.mysql.strategy.mysql.MySqlConnection;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.notification.NotificationService;
import io.debezium.pipeline.source.snapshot.incremental.IncrementalSnapshotChangeEventSource;
import io.debezium.pipeline.source.snapshot.incremental.IncrementalSnapshotContext;
import io.debezium.pipeline.source.snapshot.incremental.SignalBasedIncrementalSnapshotContext;
import io.debezium.pipeline.source.spi.DataChangeEventListener;
import io.debezium.pipeline.source.spi.SnapshotProgressListener;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.TableId;
import io.debezium.schema.DatabaseSchema;
import io.debezium.spi.schema.DataCollectionId;
import io.debezium.util.Clock;
import io.debezium.util.Strings;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MariaDbConnectorAdapter
implements ConnectorAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MariaDbConnectorAdapter.class);
    private final MySqlConnectorConfig connectorConfig;
    private final MariaDbBinaryLogClientConfigurator binaryLogClientConfigurator;

    public MariaDbConnectorAdapter(MySqlConnectorConfig connectorConfig) {
        this.connectorConfig = connectorConfig;
        this.binaryLogClientConfigurator = new MariaDbBinaryLogClientConfigurator(connectorConfig);
    }

    @Override
    public AbstractConnectorConnection createConnection(Configuration configuration) {
        MariaDbConnectionConfiguration connectionConfig = new MariaDbConnectionConfiguration(configuration);
        return new MariaDbConnection(connectionConfig, (MySqlFieldReader)new MariaDbProtocolFieldReader(this.connectorConfig));
    }

    @Override
    public BinaryLogClientConfigurator getBinaryLogClientConfigurator() {
        return this.binaryLogClientConfigurator;
    }

    @Override
    public void setOffsetContextBinlogPositionAndGtidDetailsForSnapshot(MySqlOffsetContext offsetContext, AbstractConnectorConnection connection) throws Exception {
        LOGGER.info("Read binlog position of MariaDB primary server");
        String showMasterStmt = "SHOW MASTER STATUS";
        connection.query("SHOW MASTER STATUS", rs -> {
            if (rs.next()) {
                String binlogFilename = rs.getString(1);
                long binlogPosition = rs.getLong(2);
                offsetContext.setBinlogStartPoint(binlogFilename, binlogPosition);
                connection.query("SHOW GLOBAL VARIABLES LIKE 'GTID_BINLOG_POS'", rs2 -> {
                    if (rs2.next() && rs2.getMetaData().getColumnCount() > 0) {
                        String gtidSet = rs2.getString(2);
                        offsetContext.setCompletedGtidSet(gtidSet);
                        LOGGER.info("\t using binlog '{}' at position '{}' and gtid '{}'", new Object[]{binlogFilename, binlogPosition, gtidSet});
                    } else {
                        LOGGER.info("\t using binlog '{}' at position '{}'", (Object)binlogFilename, (Object)binlogPosition);
                    }
                });
            } else if (!this.connectorConfig.getSnapshotMode().shouldStream()) {
                LOGGER.warn("Failed retrieving binlog position, continuing as streaming CDC wasn't requested");
            } else {
                throw new DebeziumException("Cannot read the binlog filename and position via 'SHOW MASTER STATUS'. Make sure your server is correctly configured");
            }
        });
    }

    @Override
    public String getRecordingQueryFromEvent(EventData eventData) {
        String query = ((AnnotateRowsEventData)eventData).getRowsQuery();
        if (!Strings.isNullOrBlank((String)this.connectorConfig.getSignalingDataCollectionId())) {
            TableId signalDataCollectionId = TableId.parse((String)this.connectorConfig.getSignalingDataCollectionId());
            if (query.toLowerCase().contains(signalDataCollectionId.toQuotedString('`').toLowerCase())) {
                return null;
            }
        }
        return query;
    }

    @Override
    public String getJavaEncodingForCharSet(String charSetName) {
        return MySqlConnection.getJavaEncodingForCharSet(charSetName);
    }

    @Override
    public AbstractHistoryRecordComparator getHistoryRecordComparator() {
        return new MariaDbHistoryRecordComparator(this.connectorConfig.gtidSourceFilter());
    }

    @Override
    public <T> IncrementalSnapshotContext<T> getIncrementalSnapshotContext() {
        if (this.connectorConfig.isReadOnlyConnection()) {
            return new MariaDbReadOnlyIncrementalSnapshotContext();
        }
        return new SignalBasedIncrementalSnapshotContext();
    }

    @Override
    public <T> IncrementalSnapshotContext<T> loadIncrementalSnapshotContextFromOffset(Map<String, ?> offset) {
        if (this.connectorConfig.isReadOnlyConnection()) {
            return MariaDbReadOnlyIncrementalSnapshotContext.load(offset);
        }
        return SignalBasedIncrementalSnapshotContext.load(offset);
    }

    @Override
    public Long getReadOnlyIncrementalSnapshotSignalOffset(MySqlOffsetContext previousOffsets) {
        return ((MariaDbReadOnlyIncrementalSnapshotContext)previousOffsets.getIncrementalSnapshotContext()).getSignalOffset();
    }

    @Override
    public IncrementalSnapshotChangeEventSource<MySqlPartition, ? extends DataCollectionId> createIncrementalSnapshotChangeEventSource(MySqlConnectorConfig connectorConfig, AbstractConnectorConnection connection, EventDispatcher<MySqlPartition, ? extends DataCollectionId> dispatcher, MySqlDatabaseSchema schema, Clock clock, SnapshotProgressListener<MySqlPartition> snapshotProgressListener, DataChangeEventListener<MySqlPartition> dataChangeEventListener, NotificationService<MySqlPartition, MySqlOffsetContext> notificationService) {
        return new MariaDbReadOnlyIncrementalSnapshotChangeEventSource<DataCollectionId>((RelationalDatabaseConnectorConfig)connectorConfig, connection, dispatcher, (DatabaseSchema<?>)schema, clock, snapshotProgressListener, dataChangeEventListener, notificationService);
    }
}

