/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql.transforms;

import io.debezium.config.Configuration;
import io.debezium.connector.mysql.Module;
import io.debezium.data.Envelope;
import io.debezium.transforms.SmtManager;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.components.Versioned;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.transforms.Transformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadToInsertEvent<R extends ConnectRecord<R>>
implements Transformation<R>,
Versioned {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReadToInsertEvent.class);
    private SmtManager<R> smtManager;

    public R apply(R record) {
        if (record.value() == null || !this.smtManager.isValidEnvelope(record)) {
            return record;
        }
        Struct originalValueStruct = (Struct)record.value();
        String operation = originalValueStruct.getString("op");
        if (!operation.equals(Envelope.Operation.READ.code())) {
            return record;
        }
        Struct updatedValueStruct = originalValueStruct.put("op", (Object)Envelope.Operation.CREATE.code());
        return (R)record.newRecord(record.topic(), record.kafkaPartition(), record.keySchema(), record.key(), record.valueSchema(), (Object)updatedValueStruct, record.timestamp());
    }

    public ConfigDef config() {
        return new ConfigDef();
    }

    public void close() {
    }

    public void configure(Map<String, ?> props) {
        Configuration config = Configuration.from(props);
        this.smtManager = new SmtManager(config);
    }

    public String version() {
        return Module.version();
    }
}

