/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import com.github.shyiko.mysql.binlog.BinaryLogClient;
import io.debezium.DebeziumException;
import io.debezium.bean.StandardBeanNames;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.connector.base.ChangeEventQueueMetrics;
import io.debezium.connector.base.DefaultQueueProvider;
import io.debezium.connector.base.QueueProvider;
import io.debezium.connector.binlog.BinlogEventMetadataProvider;
import io.debezium.connector.binlog.BinlogSourceTask;
import io.debezium.connector.binlog.jdbc.BinlogConnectorConnection;
import io.debezium.connector.binlog.jdbc.BinlogValueConverters;
import io.debezium.connector.common.CdcSourceTaskContext;
import io.debezium.connector.common.DebeziumHeaderProducer;
import io.debezium.connector.mysql.Module;
import io.debezium.connector.mysql.MySqlChangeEventSourceFactory;
import io.debezium.connector.mysql.MySqlChangeEventSourceMetricsFactory;
import io.debezium.connector.mysql.MySqlConnector;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlDatabaseSchema;
import io.debezium.connector.mysql.MySqlErrorHandler;
import io.debezium.connector.mysql.MySqlOffsetContext;
import io.debezium.connector.mysql.MySqlPartition;
import io.debezium.connector.mysql.MySqlStreamingChangeEventSourceMetrics;
import io.debezium.connector.mysql.MySqlTaskContext;
import io.debezium.connector.mysql.jdbc.MySqlConnection;
import io.debezium.connector.mysql.jdbc.MySqlConnectionConfiguration;
import io.debezium.connector.mysql.jdbc.MySqlFieldReaderResolver;
import io.debezium.connector.mysql.jdbc.MySqlValueConverters;
import io.debezium.document.DocumentReader;
import io.debezium.heartbeat.HeartbeatErrorHandler;
import io.debezium.heartbeat.HeartbeatFactory;
import io.debezium.jdbc.DefaultMainConnectionProvidingConnectionFactory;
import io.debezium.jdbc.MainConnectionProvidingConnectionFactory;
import io.debezium.pipeline.ChangeEventSourceCoordinator;
import io.debezium.pipeline.DataChangeEvent;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.GuardrailValidator;
import io.debezium.pipeline.metrics.spi.ChangeEventSourceMetricsFactory;
import io.debezium.pipeline.notification.NotificationService;
import io.debezium.pipeline.signal.SignalProcessor;
import io.debezium.pipeline.source.spi.ChangeEventSourceFactory;
import io.debezium.pipeline.source.spi.EventMetadataProvider;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Offsets;
import io.debezium.pipeline.spi.Partition;
import io.debezium.relational.CustomConverterRegistry;
import io.debezium.relational.TableId;
import io.debezium.schema.DataCollectionFilters;
import io.debezium.schema.DatabaseSchema;
import io.debezium.schema.SchemaFactory;
import io.debezium.schema.SchemaNameAdjuster;
import io.debezium.snapshot.SnapshotterService;
import io.debezium.spi.snapshot.Snapshotter;
import io.debezium.spi.topic.TopicNamingStrategy;
import io.debezium.util.Clock;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlConnectorTask
extends BinlogSourceTask<MySqlPartition, MySqlOffsetContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MySqlConnectorTask.class);
    private static final String CONTEXT_NAME = "mysql-connector-task";
    private volatile MySqlTaskContext taskContext;
    private volatile ChangeEventQueue<DataChangeEvent> queue;
    private volatile BinlogConnectorConnection connection;
    private volatile BinlogConnectorConnection beanRegistryJdbcConnection;
    private volatile ErrorHandler errorHandler;
    private volatile MySqlDatabaseSchema schema;
    private MySqlConnectorConfig connectorConfig;

    public String version() {
        return Module.version();
    }

    public CdcSourceTaskContext<? extends CommonConnectorConfig> preStart(Configuration config) {
        this.connectorConfig = new MySqlConnectorConfig(config);
        this.taskContext = new MySqlTaskContext(config, this.connectorConfig);
        return this.taskContext;
    }

    public ChangeEventSourceCoordinator<MySqlPartition, MySqlOffsetContext> start(Configuration configuration) {
        Clock clock = Clock.system();
        TopicNamingStrategy topicNamingStrategy = this.connectorConfig.getTopicNamingStrategy(MySqlConnectorConfig.TOPIC_NAMING_STRATEGY);
        SchemaNameAdjuster schemaNameAdjuster = this.connectorConfig.schemaNameAdjuster();
        MySqlValueConverters valueConverters = this.getValueConverters(this.connectorConfig);
        Configuration config = ((Configuration.Builder)((Configuration.Builder)configuration.edit().withDefault("database.responseBuffering", "adaptive").withDefault("database.fetchSize", 10000)).withDefault("database.useCursorFetch", this.connectorConfig.useCursorFetch())).build();
        DefaultMainConnectionProvidingConnectionFactory connectionFactory = new DefaultMainConnectionProvidingConnectionFactory(() -> {
            MySqlConnectionConfiguration connectionConfig = new MySqlConnectionConfiguration(config);
            return new MySqlConnection(connectionConfig, MySqlFieldReaderResolver.resolve(this.connectorConfig));
        });
        this.connection = (BinlogConnectorConnection)connectionFactory.mainConnection();
        Offsets previousOffsets = this.getPreviousOffsets(new MySqlPartition.Provider(this.connectorConfig, config), (OffsetContext.Loader)new MySqlOffsetContext.Loader(this.connectorConfig));
        boolean tableIdCaseInsensitive = this.connection.isTableIdCaseSensitive();
        this.registerServiceProviders(this.connectorConfig.getServiceRegistry());
        CustomConverterRegistry converterRegistry = (CustomConverterRegistry)this.connectorConfig.getServiceRegistry().tryGetService(CustomConverterRegistry.class);
        this.schema = new MySqlDatabaseSchema(this.connectorConfig, valueConverters, (TopicNamingStrategy<TableId>)topicNamingStrategy, schemaNameAdjuster, tableIdCaseInsensitive, converterRegistry, (CdcSourceTaskContext<? extends CommonConnectorConfig>)this.taskContext);
        this.beanRegistryJdbcConnection = (BinlogConnectorConnection)connectionFactory.newConnection();
        this.connectorConfig.getBeanRegistry().add(StandardBeanNames.CONFIGURATION, (Object)config);
        this.connectorConfig.getBeanRegistry().add("ConnectorConfig", (Object)this.connectorConfig);
        this.connectorConfig.getBeanRegistry().add("Schema", (Object)this.schema);
        this.connectorConfig.getBeanRegistry().add(StandardBeanNames.JDBC_CONNECTION, (Object)this.beanRegistryJdbcConnection);
        this.connectorConfig.getBeanRegistry().add(StandardBeanNames.VALUE_CONVERTER, (Object)valueConverters);
        this.connectorConfig.getBeanRegistry().add(StandardBeanNames.OFFSETS, (Object)previousOffsets);
        this.connectorConfig.getBeanRegistry().add(StandardBeanNames.CDC_SOURCE_TASK_CONTEXT, (Object)this.taskContext);
        SnapshotterService snapshotterService = (SnapshotterService)this.connectorConfig.getServiceRegistry().tryGetService(SnapshotterService.class);
        Snapshotter snapshotter = snapshotterService.getSnapshotter();
        this.validateBinlogConfiguration(snapshotter, this.connection);
        if (this.validateSnapshotFeasibility(snapshotter, (OffsetContext)((MySqlOffsetContext)previousOffsets.getTheOnlyOffset()), this.connection)) {
            previousOffsets.resetOffset((Partition)((MySqlPartition)previousOffsets.getTheOnlyPartition()));
        }
        if (this.connectorConfig.getGuardrailCollectionsMax() <= 0) {
            LOGGER.info("Guardrail validation skipped");
        } else {
            this.validateGuardrailLimits(this.connectorConfig, this.connection);
        }
        LOGGER.info("Closing connection before starting schema recovery");
        try {
            this.connection.close();
        }
        catch (SQLException e) {
            throw new DebeziumException((Throwable)e);
        }
        MySqlOffsetContext previousOffset = (MySqlOffsetContext)previousOffsets.getTheOnlyOffset();
        this.validateSchemaHistory((CommonConnectorConfig)this.connectorConfig, (arg_0, arg_1, arg_2) -> ((BinlogConnectorConnection)this.connection).validateLogPosition(arg_0, arg_1, arg_2), previousOffsets, (DatabaseSchema)this.schema, snapshotter);
        LOGGER.info("Reconnecting after validating schema recovery");
        try {
            try {
                this.connection.execute(new String[]{"SELECT 1"});
            }
            catch (SQLException e) {
                LOGGER.warn("Connection was dropped during schema recovery. Reconnecting...");
                try {
                    this.connection.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.connection = (BinlogConnectorConnection)connectionFactory.mainConnection();
            }
            this.connection.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw new DebeziumException("Failed to reconnect after schema recovery", (Throwable)e);
        }
        if (previousOffset == null) {
            LOGGER.info("No previous offset found");
        } else {
            LOGGER.info("Found previous offset {}", (Object)previousOffset);
        }
        this.queue = new ChangeEventQueue.Builder().pollInterval(this.connectorConfig.getPollInterval()).maxBatchSize(this.connectorConfig.getMaxBatchSize()).maxQueueSize(this.connectorConfig.getMaxQueueSize()).maxQueueSizeInBytes(this.connectorConfig.getMaxQueueSizeInBytes()).queueProvider((QueueProvider)new DefaultQueueProvider(this.connectorConfig.getMaxQueueSize())).loggingContextSupplier(() -> this.taskContext.configureLoggingContext(CONTEXT_NAME)).buffering().build();
        this.errorHandler = new MySqlErrorHandler(this.connectorConfig, this.queue, this.errorHandler);
        BinlogEventMetadataProvider metadataProvider = new BinlogEventMetadataProvider();
        SignalProcessor signalProcessor = new SignalProcessor(MySqlConnector.class, (CommonConnectorConfig)this.connectorConfig, Map.of(), this.getAvailableSignalChannels(), DocumentReader.defaultReader(), previousOffsets);
        Configuration heartbeatConfig = config;
        EventDispatcher dispatcher = new EventDispatcher((CommonConnectorConfig)this.connectorConfig, topicNamingStrategy, (DatabaseSchema)this.schema, this.queue, (DataCollectionFilters.DataCollectionFilter)this.connectorConfig.getTableFilters().dataCollectionFilter(), DataChangeEvent::new, null, (EventMetadataProvider)metadataProvider, new HeartbeatFactory().getScheduledHeartbeat((CommonConnectorConfig)this.connectorConfig, () -> new MySqlConnection(new MySqlConnectionConfiguration(heartbeatConfig), MySqlFieldReaderResolver.resolve(this.connectorConfig)), (HeartbeatErrorHandler)new BinlogSourceTask.BinlogHeartbeatErrorHandler(), this.queue), schemaNameAdjuster, signalProcessor, (DebeziumHeaderProducer)this.connectorConfig.getServiceRegistry().tryGetService(DebeziumHeaderProducer.class));
        BinaryLogClient binaryLogClient = new BinaryLogClient(this.connectorConfig.getHostName(), this.connectorConfig.getPort(), this.connectorConfig.getUserName(), this.connectorConfig.getPassword());
        MySqlStreamingChangeEventSourceMetrics streamingMetrics = new MySqlStreamingChangeEventSourceMetrics(this.taskContext, (ChangeEventQueueMetrics)this.queue, (EventMetadataProvider)metadataProvider, () -> ((MySqlDatabaseSchema)this.schema).dataCollectionIds(), binaryLogClient);
        NotificationService notificationService = new NotificationService(this.getNotificationChannels(), (CommonConnectorConfig)this.connectorConfig, SchemaFactory.get(), arg_0 -> ((EventDispatcher)dispatcher).enqueueNotification(arg_0));
        ChangeEventSourceCoordinator coordinator = new ChangeEventSourceCoordinator(previousOffsets, this.errorHandler, MySqlConnector.class, (CommonConnectorConfig)this.connectorConfig, (ChangeEventSourceFactory)new MySqlChangeEventSourceFactory(this.connectorConfig, (MainConnectionProvidingConnectionFactory<BinlogConnectorConnection>)connectionFactory, this.errorHandler, (EventDispatcher<MySqlPartition, TableId>)dispatcher, clock, this.schema, this.taskContext, streamingMetrics, this.queue, snapshotterService, binaryLogClient), (ChangeEventSourceMetricsFactory)new MySqlChangeEventSourceMetricsFactory(streamingMetrics), dispatcher, (DatabaseSchema)this.schema, signalProcessor, notificationService, snapshotterService);
        coordinator.start((CdcSourceTaskContext)this.taskContext, this.queue, (EventMetadataProvider)metadataProvider);
        return coordinator;
    }

    protected String connectorName() {
        return Module.name();
    }

    private MySqlValueConverters getValueConverters(MySqlConnectorConfig configuration) {
        return new MySqlValueConverters(configuration.getDecimalMode(), configuration.getTemporalPrecisionMode(), configuration.getBigIntUnsignedHandlingMode().asBigIntUnsignedMode(), configuration.binaryHandlingMode(), configuration.isTimeAdjustedEnabled() ? BinlogValueConverters::adjustTemporal : x -> x, configuration.getEventConvertingFailureHandlingMode(), configuration.getServiceRegistry());
    }

    public List<SourceRecord> doPoll() throws InterruptedException {
        List records = this.queue.poll();
        return records.stream().map(DataChangeEvent::getRecord).collect(Collectors.toList());
    }

    protected Optional<ErrorHandler> getErrorHandler() {
        return Optional.ofNullable(this.errorHandler);
    }

    protected void doStop() {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error("Exception while closing JDBC connection", (Throwable)e);
        }
        try {
            if (this.beanRegistryJdbcConnection != null) {
                this.beanRegistryJdbcConnection.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error("Exception while closing JDBC bean registry connection", (Throwable)e);
        }
        if (this.schema != null) {
            this.schema.close();
        }
    }

    protected Iterable<Field> getAllConfigurationFields() {
        return MySqlConnectorConfig.ALL_FIELDS;
    }

    private void validateGuardrailLimits(MySqlConnectorConfig connectorConfig, BinlogConnectorConnection connection) {
        try {
            Set allTableIds = connection.getAllTableIds();
            GuardrailValidator validator = new GuardrailValidator((CommonConnectorConfig)connectorConfig, (DatabaseSchema)this.schema);
            validator.validate(allTableIds);
        }
        catch (SQLException e) {
            throw new DebeziumException("Failed to validate guardrail limits", (Throwable)e);
        }
    }
}

