/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import java.util.regex.Pattern;

public class UnistrHelper {
    private static final String UNITSTR_FUNCTION_START = "UNISTR('";
    private static final String UNISTR_FUNCTION_END = "')";
    private static final Pattern CONCATENATION_PATTERN = Pattern.compile("\\|\\|");

    public static boolean isUnistrFunction(String data) {
        return data != null && data.startsWith(UNITSTR_FUNCTION_START) && data.endsWith(UNISTR_FUNCTION_END);
    }

    public static String convert(String data) {
        if (data == null || data.length() == 0) {
            return data;
        }
        String[] parts = CONCATENATION_PATTERN.split(data);
        StringBuilder result = new StringBuilder();
        for (String part : parts) {
            String trimmedPart = part.trim();
            if (UnistrHelper.isUnistrFunction(trimmedPart)) {
                result.append(UnistrHelper.decode(trimmedPart.substring(8, trimmedPart.length() - 2)));
                continue;
            }
            result.append(data);
        }
        return result.toString();
    }

    private static String decode(String value) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '\\' && value.length() >= i + 4) {
                result.append(Character.toChars(Integer.parseInt(value.substring(i + 1, i + 5), 16)));
                i += 4;
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }
}

