/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.processor.infinispan;

import java.util.HashMap;
import java.util.Map;

class InMemoryPendingTransactionsCache {
    private final Map<String, Integer> pendingTransactionInEventsCache = new HashMap<String, Integer>();

    InMemoryPendingTransactionsCache() {
    }

    Integer getNumPending(String transactionId) {
        return this.pendingTransactionInEventsCache.getOrDefault(transactionId, 0);
    }

    String putOrIncrement(String transactionId) {
        Integer i = this.pendingTransactionInEventsCache.getOrDefault(transactionId, 0);
        this.pendingTransactionInEventsCache.put(transactionId, i + 1);
        return transactionId;
    }

    void decrement(String transactionId) {
        int i = this.pendingTransactionInEventsCache.getOrDefault(transactionId, 0);
        if (i > 0) {
            this.pendingTransactionInEventsCache.put(transactionId, i - 1);
        }
    }

    public void initKey(String transactionId, int count) {
        this.pendingTransactionInEventsCache.put(transactionId, count);
    }

    public Integer remove(String transactionId) {
        return this.pendingTransactionInEventsCache.remove(transactionId);
    }
}

