/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.connector.oracle.AbstractOracleStreamingChangeEventSourceMetrics;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleOffsetContext;
import io.debezium.connector.oracle.OraclePartition;
import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.StreamingAdapter;
import io.debezium.document.Document;
import io.debezium.relational.RelationalSnapshotChangeEventSource;
import io.debezium.relational.TableId;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStreamingAdapter<T extends AbstractOracleStreamingChangeEventSourceMetrics>
implements StreamingAdapter<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractStreamingAdapter.class);
    protected final OracleConnectorConfig connectorConfig;

    public AbstractStreamingAdapter(OracleConnectorConfig connectorConfig) {
        this.connectorConfig = connectorConfig;
    }

    protected Scn resolveScn(Document document) {
        String scn = document.getString((CharSequence)"scn");
        if (scn == null) {
            Long scnValue = document.getLong((CharSequence)"scn");
            return Scn.valueOf(scnValue == null ? 0L : scnValue);
        }
        return Scn.valueOf(scn);
    }

    protected boolean areSameTimestamp(Scn scn1, Scn scn2, OracleConnection connection) throws SQLException {
        if (scn1 == null) {
            return false;
        }
        if (scn2 == null) {
            return false;
        }
        String query = "SELECT 1 FROM DUAL WHERE SCN_TO_TIMESTAMP(" + scn1 + ")=SCN_TO_TIMESTAMP(" + scn2 + ")";
        try (Statement s = connection.connection().createStatement();){
            boolean bl;
            block14: {
                ResultSet rs = s.executeQuery(query);
                try {
                    bl = rs.next();
                    if (rs == null) break block14;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return bl;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected Optional<Scn> getLatestTableDdlScn(RelationalSnapshotChangeEventSource.RelationalSnapshotContext<OraclePartition, OracleOffsetContext> ctx, OracleConnection connection) throws SQLException {
        if (ctx.capturedTables.isEmpty()) {
            return Optional.empty();
        }
        StringBuilder lastDdlScnQuery = new StringBuilder("SELECT TIMESTAMP_TO_SCN(MAX(last_ddl_time))").append(" FROM all_objects").append(" WHERE");
        for (TableId table : ctx.capturedTables) {
            lastDdlScnQuery.append(" (owner = '" + table.schema() + "' AND object_name = '" + table.table() + "') OR");
        }
        String query = lastDdlScnQuery.substring(0, lastDdlScnQuery.length() - 3).toString();
        try (Statement statement = connection.connection().createStatement();){
            Optional<Scn> optional;
            block22: {
                String latestDdlTime;
                ResultSet rs;
                block20: {
                    Optional<Scn> optional2;
                    block21: {
                        rs = statement.executeQuery(query);
                        try {
                            if (!rs.next()) {
                                throw new IllegalStateException("Couldn't get latest table DDL SCN");
                            }
                            latestDdlTime = rs.getString(1);
                            if (!"0".equals(latestDdlTime)) break block20;
                            optional2 = Optional.empty();
                            if (rs == null) break block21;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs.close();
                    }
                    return optional2;
                }
                optional = Optional.of(Scn.valueOf(latestDdlTime));
                if (rs == null) break block22;
                rs.close();
            }
            return optional;
        }
        catch (SQLException e) {
            if (e.getErrorCode() == 8180) {
                LOGGER.info("No latest table SCN could be resolved, defaulting to current SCN");
                return Optional.empty();
            }
            throw e;
        }
    }
}

