/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleDatabaseSchema;
import io.debezium.connector.oracle.OracleOffsetContext;
import io.debezium.connector.oracle.OraclePartition;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.jdbc.MainConnectionProvidingConnectionFactory;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.notification.NotificationService;
import io.debezium.pipeline.source.AbstractSnapshotChangeEventSource;
import io.debezium.pipeline.source.SnapshottingTask;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.pipeline.source.spi.SnapshotProgressListener;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.RelationalDatabaseSchema;
import io.debezium.relational.RelationalSnapshotChangeEventSource;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.schema.SchemaChangeEvent;
import io.debezium.snapshot.SnapshotterService;
import io.debezium.util.Clock;
import io.debezium.util.Strings;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.kafka.connect.errors.ConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleSnapshotChangeEventSource
extends RelationalSnapshotChangeEventSource<OraclePartition, OracleOffsetContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OracleSnapshotChangeEventSource.class);
    private final OracleConnectorConfig connectorConfig;
    private final OracleConnection jdbcConnection;
    private final OracleDatabaseSchema databaseSchema;

    public OracleSnapshotChangeEventSource(OracleConnectorConfig connectorConfig, MainConnectionProvidingConnectionFactory<OracleConnection> connectionFactory, OracleDatabaseSchema schema, EventDispatcher<OraclePartition, TableId> dispatcher, Clock clock, SnapshotProgressListener<OraclePartition> snapshotProgressListener, NotificationService<OraclePartition, OracleOffsetContext> notificationService, SnapshotterService snapshotterService) {
        super((RelationalDatabaseConnectorConfig)connectorConfig, connectionFactory, (RelationalDatabaseSchema)schema, dispatcher, clock, snapshotProgressListener, notificationService, snapshotterService);
        this.connectorConfig = connectorConfig;
        this.jdbcConnection = (OracleConnection)connectionFactory.mainConnection();
        this.databaseSchema = schema;
    }

    protected AbstractSnapshotChangeEventSource.SnapshotContext<OraclePartition, OracleOffsetContext> prepare(OraclePartition partition, boolean onDemand) {
        if (this.connectorConfig.getPdbName() != null) {
            this.jdbcConnection.setSessionToPdb(this.connectorConfig.getPdbName());
        }
        return new OracleSnapshotContext(partition, this.connectorConfig.getCatalogName(), onDemand);
    }

    protected void connectionPoolConnectionCreated(RelationalSnapshotChangeEventSource.RelationalSnapshotContext<OraclePartition, OracleOffsetContext> snapshotContext, JdbcConnection connection) {
        if (this.connectorConfig.getPdbName() != null) {
            ((OracleConnection)connection).setSessionToPdb(this.connectorConfig.getPdbName());
        }
    }

    protected Set<TableId> getAllTableIds(RelationalSnapshotChangeEventSource.RelationalSnapshotContext<OraclePartition, OracleOffsetContext> ctx) throws Exception {
        return this.jdbcConnection.getAllTableIds(ctx.catalogName);
    }

    protected void lockTablesForSchemaSnapshot(ChangeEventSource.ChangeEventSourceContext sourceContext, RelationalSnapshotChangeEventSource.RelationalSnapshotContext<OraclePartition, OracleOffsetContext> snapshotContext) throws SQLException, InterruptedException {
        if (this.connectorConfig.getSnapshotLockingMode().get().usesLocking()) {
            ((OracleSnapshotContext)snapshotContext).preSchemaSnapshotSavepoint = this.jdbcConnection.connection().setSavepoint("dbz_schema_snapshot");
            try (Statement statement = this.jdbcConnection.connection().createStatement();){
                for (TableId tableId : snapshotContext.capturedTables) {
                    if (!sourceContext.isRunning()) {
                        throw new InterruptedException("Interrupted while locking table " + tableId);
                    }
                    Optional lockingStatement = this.snapshotterService.getSnapshotLock().tableLockingStatement(null, this.quote(tableId));
                    if (!lockingStatement.isPresent()) continue;
                    LOGGER.debug("Locking table {}", (Object)tableId);
                    statement.execute((String)lockingStatement.get());
                }
            }
        } else {
            LOGGER.info("Schema locking was disabled in connector configuration");
        }
    }

    protected void releaseSchemaSnapshotLocks(RelationalSnapshotChangeEventSource.RelationalSnapshotContext<OraclePartition, OracleOffsetContext> snapshotContext) throws SQLException {
        if (this.connectorConfig.getSnapshotLockingMode().get().usesLocking()) {
            this.jdbcConnection.connection().rollback(((OracleSnapshotContext)snapshotContext).preSchemaSnapshotSavepoint);
        }
    }

    protected void determineSnapshotOffset(RelationalSnapshotChangeEventSource.RelationalSnapshotContext<OraclePartition, OracleOffsetContext> ctx, OracleOffsetContext previousOffset) throws Exception {
        if (this.connectorConfig.getSnapshotMode() != OracleConnectorConfig.SnapshotMode.ALWAYS && previousOffset != null) {
            ctx.offset = previousOffset;
            this.tryStartingSnapshot(ctx);
            return;
        }
        ctx.offset = this.connectorConfig.getAdapter().determineSnapshotOffset(ctx, this.connectorConfig, this.jdbcConnection);
    }

    protected void readTableStructure(ChangeEventSource.ChangeEventSourceContext sourceContext, RelationalSnapshotChangeEventSource.RelationalSnapshotContext<OraclePartition, OracleOffsetContext> snapshotContext, OracleOffsetContext offsetContext, SnapshottingTask snapshottingTask) throws SQLException, InterruptedException {
        Set capturedSchemaTables;
        if (this.databaseSchema.storeOnlyCapturedTables()) {
            capturedSchemaTables = snapshotContext.capturedTables;
            LOGGER.info("Only captured tables schema should be captured, capturing: {}", (Object)capturedSchemaTables);
        } else {
            capturedSchemaTables = snapshotContext.capturedSchemaTables;
            LOGGER.info("All eligible tables schema should be captured, capturing: {}", (Object)capturedSchemaTables);
        }
        Set schemas = capturedSchemaTables.stream().map(TableId::schema).collect(Collectors.toSet());
        Tables.TableFilter tableFilter = this.getTableFilter(snapshottingTask, snapshotContext);
        for (String schema : schemas) {
            if (!sourceContext.isRunning()) {
                throw new InterruptedException("Interrupted while reading structure of schema " + schema);
            }
            this.jdbcConnection.readSchema(snapshotContext.tables, null, schema, tableFilter, null, false);
        }
    }

    private Tables.TableFilter getTableFilter(SnapshottingTask snapshottingTask, RelationalSnapshotChangeEventSource.RelationalSnapshotContext<OraclePartition, OracleOffsetContext> snapshotContext) {
        if (snapshottingTask.isOnDemand()) {
            return Tables.TableFilter.fromPredicate(snapshotContext.capturedTables::contains);
        }
        return this.connectorConfig.storeOnlyCapturedTables() ? this.connectorConfig.getTableFilters().dataCollectionFilter() : null;
    }

    protected String enhanceOverriddenSelect(RelationalSnapshotChangeEventSource.RelationalSnapshotContext<OraclePartition, OracleOffsetContext> snapshotContext, String overriddenSelect, TableId tableId) {
        String snapshotOffset = (String)((OracleOffsetContext)snapshotContext.offset).getOffset().get("scn");
        String token = this.connectorConfig.getTokenToReplaceInSnapshotPredicate();
        if (token != null) {
            return overriddenSelect.replaceAll(token, " AS OF SCN " + snapshotOffset);
        }
        return overriddenSelect;
    }

    protected Collection<TableId> getTablesForSchemaChange(RelationalSnapshotChangeEventSource.RelationalSnapshotContext<OraclePartition, OracleOffsetContext> snapshotContext) {
        return snapshotContext.capturedSchemaTables;
    }

    protected SchemaChangeEvent getCreateTableEvent(RelationalSnapshotChangeEventSource.RelationalSnapshotContext<OraclePartition, OracleOffsetContext> snapshotContext, Table table) throws SQLException {
        return SchemaChangeEvent.ofCreate((Partition)snapshotContext.partition, (OffsetContext)snapshotContext.offset, (String)snapshotContext.catalogName, (String)table.id().schema(), (String)this.jdbcConnection.getTableMetadataDdl(table.id()), (Table)table, (boolean)true);
    }

    protected Instant getSnapshotSourceTimestamp(JdbcConnection jdbcConnection, OracleOffsetContext offset, TableId tableId) {
        try {
            Optional<Instant> snapshotTs = ((OracleConnection)jdbcConnection).getScnToTimestamp(offset.getScn());
            if (snapshotTs.isEmpty()) {
                throw new ConnectException("Failed reading SCN timestamp from source database");
            }
            return snapshotTs.get();
        }
        catch (SQLException e) {
            throw new ConnectException("Failed reading SCN timestamp from source database", (Throwable)e);
        }
    }

    protected Optional<String> getSnapshotSelect(RelationalSnapshotChangeEventSource.RelationalSnapshotContext<OraclePartition, OracleOffsetContext> snapshotContext, TableId tableId, List<String> columns) {
        return this.snapshotterService.getSnapshotQuery().snapshotQuery(this.quote(tableId), columns);
    }

    protected List<Pattern> getSignalDataCollectionPattern(String signalingDataCollection) {
        TableId tableId = TableId.parse((String)signalingDataCollection);
        return Strings.listOfRegex((String)(tableId.schema() + "." + tableId.table()), (int)2);
    }

    public void close() {
        if (this.connectorConfig.getPdbName() != null) {
            this.jdbcConnection.resetSessionToCdb();
        }
    }

    private String quote(TableId tableId) {
        return new TableId(null, tableId.schema(), tableId.table()).toDoubleQuotedString();
    }

    protected OracleOffsetContext copyOffset(RelationalSnapshotChangeEventSource.RelationalSnapshotContext<OraclePartition, OracleOffsetContext> snapshotContext) {
        return this.connectorConfig.getAdapter().copyOffset(this.connectorConfig, (OracleOffsetContext)snapshotContext.offset);
    }

    protected Callable<Void> createDataEventsForTableCallable(ChangeEventSource.ChangeEventSourceContext sourceContext, RelationalSnapshotChangeEventSource.RelationalSnapshotContext<OraclePartition, OracleOffsetContext> snapshotContext, EventDispatcher.SnapshotReceiver<OraclePartition> snapshotReceiver, Table table, boolean firstTable, boolean lastTable, int tableOrder, int tableCount, String selectStatement, OptionalLong rowCount, Queue<JdbcConnection> connectionPool, Queue<OracleOffsetContext> offsets) {
        return () -> {
            JdbcConnection connection = (JdbcConnection)connectionPool.poll();
            OracleOffsetContext offset = (OracleOffsetContext)((Object)((Object)offsets.poll()));
            try {
                int maxRetries = this.getTableSnapshotMaxRetries();
                for (int i = 0; i <= maxRetries; ++i) {
                    try {
                        this.doCreateDataEventsForTable(sourceContext, snapshotContext, (OffsetContext)offset, snapshotReceiver, table, firstTable, lastTable, tableOrder, tableCount, selectStatement, rowCount, connection);
                        break;
                    }
                    catch (SQLException e) {
                        this.notificationService.initialSnapshotNotificationService().notifyCompletedTableWithError((Partition)((OraclePartition)snapshotContext.partition), snapshotContext.offset, table.id().identifier());
                        if (maxRetries <= 0 || !this.isTableSnapshotErrorRetriable(e) || i + 1 > maxRetries) {
                            throw new ConnectException("Snapshotting of table " + table.id() + " failed", (Throwable)e);
                        }
                        LOGGER.warn("Table {} snapshot failed: {}, attempting to retry ({} of {})", new Object[]{table.id(), e.getMessage(), i, this.getTableSnapshotMaxRetries()});
                        continue;
                    }
                }
            }
            finally {
                offsets.add(offset);
                connectionPool.add(connection);
            }
            return null;
        };
    }

    private int getTableSnapshotMaxRetries() {
        return this.connectorConfig.getSnapshotRetryDatabaseErrorsMaxRetries();
    }

    protected boolean isTableSnapshotErrorRetriable(SQLException exception) {
        return exception.getErrorCode() == 1466;
    }

    private static class OracleSnapshotContext
    extends RelationalSnapshotChangeEventSource.RelationalSnapshotContext<OraclePartition, OracleOffsetContext> {
        private Savepoint preSchemaSnapshotSavepoint;

        OracleSnapshotContext(OraclePartition partition, String catalogName, boolean onDemand) {
            super((Partition)partition, catalogName, onDemand);
        }
    }
}

