/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.antlr.listener;

import io.debezium.connector.oracle.antlr.OracleDdlParser;
import io.debezium.connector.oracle.antlr.listener.BaseParserListener;
import io.debezium.connector.oracle.antlr.listener.ColumnDefinitionParserListener;
import io.debezium.ddl.parser.oracle.generated.PlSqlParser;
import io.debezium.relational.Column;
import io.debezium.relational.ColumnEditor;
import io.debezium.relational.Table;
import io.debezium.relational.TableEditor;
import io.debezium.relational.TableId;
import io.debezium.text.ParsingException;
import java.util.List;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateTableParserListener
extends BaseParserListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateTableParserListener.class);
    private final List<ParseTreeListener> listeners;
    private TableEditor tableEditor;
    private String catalogName;
    private String schemaName;
    private OracleDdlParser parser;
    private ColumnDefinitionParserListener columnDefinitionParserListener;
    private String inlinePrimaryKey;

    CreateTableParserListener(String catalogName, String schemaName, OracleDdlParser parser, List<ParseTreeListener> listeners) {
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.parser = parser;
        this.listeners = listeners;
    }

    public void enterCreate_table(PlSqlParser.Create_tableContext ctx) {
        if (ctx.relational_table() == null) {
            throw new ParsingException(null, "Only relational tables are supported");
        }
        TableId tableId = new TableId(this.catalogName, this.schemaName, this.getTableName(ctx.tableview_name()));
        if (this.parser.getTableFilter().isIncluded(tableId)) {
            if (this.parser.databaseTables().forTable(tableId) == null) {
                this.tableEditor = this.parser.databaseTables().editOrCreateTable(tableId);
                super.enterCreate_table(ctx);
            }
        } else {
            LOGGER.debug("Ignoring CREATE TABLE statement for non-captured table {}", (Object)tableId);
        }
    }

    public void exitCreate_table(PlSqlParser.Create_tableContext ctx) {
        this.parser.runIfNotNull(() -> {
            if (this.inlinePrimaryKey != null) {
                if (!this.tableEditor.primaryKeyColumnNames().isEmpty()) {
                    throw new ParsingException(null, "Can only specify in-line or out-of-line primary keys but not both");
                }
                this.tableEditor.setPrimaryKeyNames(new String[]{this.inlinePrimaryKey});
            }
            Table table = this.getTable();
            assert (table != null);
            this.parser.runIfNotNull(() -> {
                this.listeners.remove((Object)this.columnDefinitionParserListener);
                this.columnDefinitionParserListener = null;
                this.parser.databaseTables().overwriteTable(table);
                this.parser.signalCreateTable(this.tableEditor.tableId(), (ParserRuleContext)ctx);
            }, table);
        }, this.tableEditor);
        super.exitCreate_table(ctx);
    }

    public void enterColumn_definition(PlSqlParser.Column_definitionContext ctx) {
        this.parser.runIfNotNull(() -> {
            String columnName = this.getColumnName(ctx.column_name());
            ColumnEditor columnEditor = Column.editor().name(columnName);
            if (this.columnDefinitionParserListener == null) {
                this.columnDefinitionParserListener = new ColumnDefinitionParserListener(this.tableEditor, columnEditor, this.parser, this.listeners);
                this.columnDefinitionParserListener.enterColumn_definition(ctx);
                this.listeners.add((ParseTreeListener)this.columnDefinitionParserListener);
            } else {
                this.columnDefinitionParserListener.setColumnEditor(columnEditor);
            }
        }, this.tableEditor);
        super.enterColumn_definition(ctx);
    }

    public void exitColumn_definition(PlSqlParser.Column_definitionContext ctx) {
        this.parser.runIfNotNull(() -> this.tableEditor.addColumn(this.columnDefinitionParserListener.getColumn()), new Object[]{this.tableEditor, this.columnDefinitionParserListener});
        super.exitColumn_definition(ctx);
    }

    public void exitInline_constraint(PlSqlParser.Inline_constraintContext ctx) {
        if (ctx.PRIMARY() != null && ctx.getParent() instanceof PlSqlParser.Column_definitionContext) {
            PlSqlParser.Column_definitionContext columnCtx = (PlSqlParser.Column_definitionContext)ctx.getParent();
            this.inlinePrimaryKey = this.getColumnName(columnCtx.column_name());
        }
        super.exitInline_constraint(ctx);
    }

    public void exitOut_of_line_constraint(PlSqlParser.Out_of_line_constraintContext ctx) {
        this.parser.runIfNotNull(() -> {
            if (ctx.PRIMARY() != null) {
                if (this.inlinePrimaryKey != null) {
                    throw new ParsingException(null, "Cannot specify inline and out of line primary keys");
                }
                List pkColumnNames = ctx.column_name().stream().map(this::getColumnName).collect(Collectors.toList());
                this.tableEditor.setPrimaryKeyNames(pkColumnNames);
            }
        }, this.tableEditor);
        super.exitOut_of_line_constraint(ctx);
    }

    private Table getTable() {
        return this.tableEditor != null ? this.tableEditor.create() : null;
    }
}

