/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import io.debezium.DebeziumException;
import io.debezium.connector.oracle.BaseChangeRecordEmitter;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleDatabaseSchema;
import io.debezium.connector.oracle.logminer.events.EventType;
import io.debezium.connector.oracle.util.TimestampUtils;
import io.debezium.data.Envelope;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import io.debezium.relational.Column;
import io.debezium.relational.Table;
import io.debezium.util.Clock;
import io.debezium.util.Strings;
import java.sql.Connection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogMinerChangeRecordEmitter
extends BaseChangeRecordEmitter<Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogMinerChangeRecordEmitter.class);
    private final Envelope.Operation operation;

    public LogMinerChangeRecordEmitter(OracleConnectorConfig connectorConfig, Partition partition, OffsetContext offset, Envelope.Operation operation, Object[] oldValues, Object[] newValues, Table table, OracleDatabaseSchema schema, Clock clock) {
        super(connectorConfig, partition, offset, schema, table, clock, oldValues, newValues);
        this.operation = operation;
    }

    public LogMinerChangeRecordEmitter(OracleConnectorConfig connectorConfig, Partition partition, OffsetContext offset, EventType eventType, Object[] oldValues, Object[] newValues, Table table, OracleDatabaseSchema schema, Clock clock) {
        this(connectorConfig, partition, offset, LogMinerChangeRecordEmitter.getOperation(eventType), oldValues, newValues, table, schema, clock);
    }

    private static Envelope.Operation getOperation(EventType eventType) {
        switch (eventType) {
            case INSERT: {
                return Envelope.Operation.CREATE;
            }
            case UPDATE: 
            case SELECT_LOB_LOCATOR: 
            case XML_BEGIN: {
                return Envelope.Operation.UPDATE;
            }
            case DELETE: {
                return Envelope.Operation.DELETE;
            }
        }
        throw new DebeziumException("Unsupported operation type: " + String.valueOf((Object)eventType));
    }

    public Envelope.Operation getOperation() {
        return this.operation;
    }

    @Override
    protected Object convertReselectPrimaryKeyColumn(Connection connection, Column column, Object value) {
        if (value instanceof String) {
            switch (column.jdbcType()) {
                case 91: 
                case 93: {
                    String formattedTimestamp = TimestampUtils.toSqlCompliantFunctionCall((String)value);
                    if (Strings.isNullOrBlank((String)formattedTimestamp)) break;
                    value = this.convertValueViaQuery(connection, formattedTimestamp);
                    break;
                }
                case -104: 
                case -103: {
                    value = this.convertValueViaQuery(connection, (String)value);
                    break;
                }
            }
        }
        return value;
    }
}

