/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.parser;

import io.debezium.connector.oracle.logminer.LogMinerHelper;
import io.debezium.connector.oracle.logminer.parser.LogMinerDmlEntry;
import io.debezium.connector.oracle.logminer.parser.ParserUtils;
import io.debezium.relational.Table;
import io.debezium.text.ParsingException;
import io.debezium.util.Strings;
import java.util.function.Consumer;

public abstract class PreambleSingleColumnReconstructedSelectParser {
    private static final String SELECT = "select";
    private static final String INTO = "into";
    private static final String FROM = "from";
    private static final String WHERE = "where";
    private static final String AND = "and";
    private static final String OR = "or";
    private static final String FOR_UPDATE = "for update";
    private final String preamble;
    private String columnName;
    private String schemaName;
    private String tableName;
    private Object[] columnValues;

    public PreambleSingleColumnReconstructedSelectParser(String preamble) {
        this.preamble = preamble;
    }

    public LogMinerDmlEntry parse(String sql, Table table) {
        this.reset(table);
        if (!Strings.isNullOrBlank((String)sql)) {
            try {
                int startIndex = sql.indexOf(this.preamble);
                if (startIndex == -1) {
                    throw new IllegalStateException("Failed to locate preamble: " + this.preamble);
                }
                startIndex = sql.indexOf(" ", startIndex + this.preamble.length() + 1);
                if ((startIndex = sql.indexOf(SELECT, startIndex)) == -1) {
                    throw new IllegalStateException("Failed to locate SELECT keyword");
                }
                startIndex = sql.indexOf(" ", startIndex) + 1;
                startIndex = this.parseSelectable(sql, startIndex, table);
                if (this.startsWithAtIndex(INTO, startIndex = sql.indexOf(" ", startIndex) + 1, sql)) {
                    startIndex += INTO.length() + 1;
                    startIndex = this.parseIntoClause(sql, startIndex);
                }
                if (this.startsWithAtIndex(FROM, startIndex, sql)) {
                    startIndex += FROM.length() + 1;
                    startIndex = this.parseFromClause(sql, startIndex);
                }
                if (this.startsWithAtIndex(WHERE, startIndex, sql)) {
                    startIndex += WHERE.length() + 1;
                    startIndex = this.parseWhereClause(sql, startIndex, table);
                }
                ParserUtils.setColumnUnavailableValues(this.columnValues, table);
            }
            catch (Throwable t) {
                throw new ParsingException(null, "Parsing failed for SQL: '" + sql + "'", t);
            }
        }
        LogMinerDmlEntry entry = this.createDmlEntryForColumnValues(this.columnValues);
        entry.setObjectOwner(this.schemaName);
        entry.setObjectName(this.tableName);
        return entry;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    protected int parseQuotedValue(String sql, int index, Consumer<String> collector) {
        boolean inDoubleQuotes = false;
        int startIndex = -1;
        int lastIndex = -1;
        for (int i = index; i < sql.length(); ++i) {
            if (sql.charAt(i) != '\"') continue;
            if (!inDoubleQuotes) {
                inDoubleQuotes = true;
                startIndex = i + 1;
                continue;
            }
            inDoubleQuotes = false;
            lastIndex = i;
            index = i + 1;
            break;
        }
        if (startIndex != -1 && lastIndex != -1) {
            collector.accept(sql.substring(startIndex, lastIndex));
        }
        return index;
    }

    protected int parseSelectable(String sql, int index, Table table) {
        return this.parseQuotedValue(sql, index, value -> {
            if (table.columnWithName(value) == null) {
                throw new IllegalStateException("No column named " + value + " found in table " + String.valueOf(table.id()));
            }
            this.columnName = value;
        });
    }

    protected int parseIntoClause(String sql, int index) {
        return index;
    }

    protected int parseFromClause(String sql, int index) {
        if (sql.charAt(index = this.parseQuotedValue(sql, index, value -> {
            this.schemaName = value;
        })) != '.') {
            throw new IllegalStateException("Expected object with format \"<schema>\".\"<table>\"");
        }
        ++index;
        index = this.parseQuotedValue(sql, index, value -> {
            this.tableName = value;
        });
        return ++index;
    }

    protected int parseWhereClause(String sql, int index, Table table) {
        for (int i = index; i < sql.length(); ++i) {
            StringBuilder columnName = new StringBuilder();
            index = this.parseQuotedValue(sql, index, columnName::append);
            index = this.parseOperator(sql, index);
            index = this.parseColumnValue(sql, index, LogMinerHelper.getColumnIndexByName(columnName.toString(), table));
            if (sql.indexOf(AND, ++index) == index) {
                index += AND.length() + 1;
                continue;
            }
            if (sql.indexOf(OR, index) == index) {
                index += OR.length() + 1;
                continue;
            }
            if (sql.indexOf(FOR_UPDATE, index) == index || index >= sql.length()) break;
        }
        return index;
    }

    protected int parseOperator(String sql, int index) {
        boolean initialSpace = false;
        for (int i = index; i < sql.length(); ++i) {
            char lookAhead;
            char c = sql.charAt(i);
            char c2 = lookAhead = i + 1 < sql.length() ? sql.charAt(i + 1) : (char)'\u0000';
            if (initialSpace || c != ' ') {
                if (initialSpace && c == '=' && lookAhead == ' ') {
                    index += 3;
                    break;
                }
                if (initialSpace && c == 'I' && lookAhead == 'S') {
                    char lookAhead2;
                    char c3 = lookAhead2 = i + 2 < sql.length() ? sql.charAt(i + 2) : (char)'\u0000';
                    if (lookAhead2 == ' ') {
                        index += 4;
                        break;
                    }
                    throw new ParsingException(null, "Expected 'IS' at index " + i + ": " + sql);
                }
                throw new ParsingException(null, "Failed to parse operator at index " + i + ": " + sql);
            }
            initialSpace = true;
        }
        return index;
    }

    protected int parseColumnValue(String sql, int index, int columnIndex) {
        boolean inSingleQuotes = false;
        int start = -1;
        int last = -1;
        int nested = 0;
        for (int i = index; i < sql.length(); ++i) {
            char lookAhead;
            char c = sql.charAt(i);
            char c2 = lookAhead = i + 1 < sql.length() ? sql.charAt(i + 1) : (char)'\u0000';
            if (i == index && c != '\'') {
                start = i;
                continue;
            }
            if (c == '(' && !inSingleQuotes) {
                ++nested;
                continue;
            }
            if (c == ')' && !inSingleQuotes) {
                if (--nested != 0) continue;
                last = i + 1;
                index = i + 1;
                break;
            }
            if (c == '\'') {
                if (inSingleQuotes && lookAhead == '\'') {
                    ++i;
                    continue;
                }
                if (inSingleQuotes) {
                    inSingleQuotes = false;
                    if (nested != 0) continue;
                    last = i;
                    index = i + 1;
                    break;
                }
                inSingleQuotes = true;
                if (nested != 0) continue;
                start = i + 1;
                continue;
            }
            if (c != ' ' || inSingleQuotes || nested != 0) continue;
            last = i;
            index = i;
            break;
        }
        if (start != -1) {
            String value;
            if (last != -1) {
                value = sql.substring(start, last);
            } else {
                value = sql.substring(start);
                index = sql.length();
            }
            if (!value.equalsIgnoreCase("null")) {
                this.columnValues[columnIndex] = value;
            }
        }
        return index;
    }

    protected void reset(Table table) {
        this.columnName = null;
        this.schemaName = null;
        this.tableName = null;
        this.columnValues = new Object[table.columns().size()];
    }

    protected abstract LogMinerDmlEntry createDmlEntryForColumnValues(Object[] var1);

    private boolean startsWithAtIndex(String startsWithValue, int index, String value) {
        for (int i = 0; i < startsWithValue.length(); ++i) {
            if (value.charAt(index++) == startsWithValue.charAt(i)) continue;
            return false;
        }
        return true;
    }
}

